/**
 * tp_cond.h
 *
 * Abstract condition object
 * and simplest real condition object
 * 
 * (c) 2005 Peppercon AG, 23/06/2005, tbr@peppecon.de
 */

#ifndef _PP_BMC_TP_COND_H
#define _PP_BMC_TP_COND_H

#include <pp/bmc/tp_sensdev.h>

/**
 * A condition has a method that can dynamically
 * decide whether a condition is true of false
 */
typedef struct {
    pp_tp_sensdev_t base;
    /* lock for access from scanner thread within update functions */
    pthread_mutex_t mtx;
} pp_tp_cond_t;

int pp_tp_cond_init(pp_tp_cond_t* this, pp_tp_obj_type_t type, const char* id,
		    pp_tp_obj_dtor_func_t dtor);

/* Must be used by derived classes to set a new value. *
 * Never ever that reading value directly!!!           *
 * This will trigger subscriber notification.          *
 * Makes sure locking is handled correctly             */
void pp_tp_cond_set_reading(pp_tp_cond_t* this, int reading);

void pp_tp_cond_lock(pp_tp_cond_t* this);
void pp_tp_cond_unlock(pp_tp_cond_t* this);

/* may also return -1 (invalid reading), not just true and false */
int pp_tp_cond_get_reading(pp_tp_cond_t* this);


/* returns boolean, invalid reading is considered false */
int pp_bmc_tp_cond_is_true(pp_tp_cond_t* this);

static inline void pp_tp_cond_cleanup(pp_tp_cond_t* this) {
    pp_tp_sensdev_cleanup(&this->base);
}

static inline pp_tp_cond_t* pp_tp_cond_duplicate(pp_tp_cond_t* this) {
    return this == NULL ? NULL :
	(pp_tp_cond_t*)pp_tp_obj_duplicate((pp_tp_obj_t*)this);
}

static inline void pp_tp_cond_release(pp_tp_cond_t* this) {
    pp_tp_obj_release((pp_tp_obj_t*)this);
}

static inline const char* pp_tp_cond_to_string(pp_tp_cond_t* this) {
    return pp_tp_obj_to_string((pp_tp_obj_t*)this);
}

static inline void pp_tp_cond_subscribe(pp_tp_cond_t* this,
					pp_tp_sensdev_subscriber_t* s) {
    pp_bmc_tp_sensdev_subscribe(&this->base, s);
}

static inline int pp_tp_cond_unsubscribe(pp_tp_cond_t* this,
					 pp_tp_sensdev_subscriber_t* s) {
    return pp_bmc_tp_sensdev_unsubscribe(&this->base, s);
}

static inline void pp_tp_cond_notify_subscribers(pp_tp_cond_t* this,
						 int reading) {
    pp_bmc_tp_sensdev_notify_subscribers(&this->base, reading);
}

#endif /* _PP_BMC_TP_COND_H */
