/**
 * tp_ctrl.h
 *
 * Abstract controller  object
 * 
 * (c) 2005 Peppercon AG, 22/05/2005, tbr@peppecon.de
 */

#ifndef _PP_BMC_TP_CTRL_H
#define _PP_BMC_TP_CTRL_H

#include <pp/bmc/topo_base_obj.h>
#include <pp/bmc/tp_sens_subscriber.h>

typedef struct {
    pp_tp_obj_t base;
} pp_tp_ctrl_t;

static inline int
pp_tp_ctrl_init(pp_tp_ctrl_t* this, pp_tp_obj_type_t type, const char* id,
		pp_tp_obj_dtor_func_t dtor)
{
    return pp_tp_obj_init(&this->base, type, id, dtor);
}

static inline void
pp_tp_ctrl_cleanup(pp_tp_ctrl_t* this)
{
    pp_tp_obj_cleanup(&this->base);
}

static inline pp_tp_ctrl_t*
pp_tp_ctrl_duplicate(pp_tp_ctrl_t* this) {
    return (pp_tp_ctrl_t*)pp_tp_obj_duplicate(&this->base);
}

#endif /* _PP_BMC_TP_CTRL_H */
