/**
 * tp_gpio_loop.h
 *
 * Loop actor, connects an input gpio to an output gpio.
 * 
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

#ifndef __PP_BMC_TP_GPIO_LOOP_H__
#define __PP_BMC_TP_GPIO_LOOP_H__

#include <pp/bmc/tp_ctrl.h>
#include <pp/bmc/tp_gpio_sens.h>
#include <pp/bmc/tp_gpio_act.h>

struct pp_tp_gpio_loop_s {
    pp_tp_ctrl_t base;
    
    pp_tp_sensdev_subscriber_t subscriber;

    /* our parameters, we will connect 'in' to 'out' */
    pp_tp_gpio_sens_t* in;
    pp_tp_gpio_act_t* out;
    
};
typedef struct pp_tp_gpio_loop_s pp_tp_gpio_loop_t;


/**
 * initializer
 */
void pp_tp_gpio_loop_init(pp_tp_gpio_loop_t* d, const char* id,
                          pp_tp_gpio_sens_t* gpio_sens,
			  pp_tp_gpio_act_t* gpio_act);

/* ppdoc
 * name:   GPIO loop controller
 * tpname: GpioLoopCtrl
 * desc:   Connect a gpio sensor directly to a gpio actor. The gpio actor
 * desc:   will always reflect the state of the gpio sensor.
 * arg 0:  [OBJ(GPIO_SENS)] sens: The sensor to read
 * arg 1:  [OBJ(GPIO_ACT)] act:   The actor to feedback the signal.
 * return: [OBJ(CTRL)]
 */
pp_tp_obj_t* pp_tp_gpio_loop_ctor(const char* id, vector_t* args);


#endif
