/**
 * tp_gpio_multi_act.h
 *
 * Actor, setting a collection of gpios at ones
 * currently rudimentary in terms of features.
 * 
 * (c) 2005 Peppercon AG, tbr@peppercon.de
 */

#ifndef __PP_BMC_TP_GPIO_MULTI_ACT_H__
#define __PP_BMC_TP_GPIO_MULTI_ACT_H__

#include <pp/base.h>
#include <pp/bmc/tp_actor.h>
#include <pp/bmc/tp_gpio_dev.h>

typedef struct pp_tp_gpio_multi_act_s {
    pp_tp_actor_t base;

    /* total number of gpios affected */
    int gpio_cnt;

    /* number of different gpio devices */
    int gpio_desc_cnt;

    /* gpio devices this multi act uses */
    vector_t* gpio_desc;

    /* last value set using this actor */
    int last_value;
    
    /* set multiple gpio pins to their value or tristate */
    int (*set_value)(struct pp_tp_gpio_multi_act_s* o,
		     unsigned int val, unsigned int tri);
} pp_tp_gpio_multi_act_t;

/* ppdoc
 * name:   GPIO multi actor
 * tpname: GpioMultiAct
 * desc:   Allows to write a complete set of gpio pins. The 
 * desc:   order of the bits corresponds to the order of the
 * desc:   arguments in the constructor.
 * desc:   EXAMPLE USAGE:
 * desc:   GpioMultiAct(dev_B, 4, 1,   7, 1,   0, 2,
 * desc:                dev_A, 1, 2,
 * desc:                dev_C, 5, 2,   1, 2,   2, 0);
 * arg 0:  [OBJ(GPIO_DEV)] gpiodev: gpio device to use
 * arg 1:  [INT] signal1:           gpio number to use with gpio-dev
 * arg 2:  [INT] initial1:          initial state of the gpio (0, 1 or 2=tristate)
 * arg 3:  [...]:                   (optional, repeatable) more gpio numbers can be appended to
 * arg 3:                           add more signals from the gpio device
 * arg 4:  [...]:                   (optional, repeatable) arguments 1..n (GPIO_DEV, INT, ...) 
 * arg 4:                           can be repeated to add signals from different 
 * arg 4:                           gpio devices to the actor.
 * return: [OBJ(GPIO_MULTI_ACT)]
 */
pp_tp_obj_t* pp_tp_gpio_multi_act_ctor(const char* id, vector_t* args);

static inline int pp_tp_gpio_multi_act_set(pp_tp_gpio_multi_act_t* this,
					   unsigned int val, unsigned int tri)
{
    return this->set_value(this, val, tri);
}

int pp_tp_gpio_multi_act_get_last(pp_tp_gpio_multi_act_t* this);

static inline pp_tp_gpio_multi_act_t*
pp_tp_gpio_multi_act_duplicate(pp_tp_gpio_multi_act_t* this) {
    return (pp_tp_gpio_multi_act_t*)pp_tp_obj_duplicate((pp_tp_obj_t*)this);
}

static inline void
pp_tp_gpio_multi_act_release(pp_tp_gpio_multi_act_t* this) {
    pp_tp_obj_release((pp_tp_obj_t*)this);
}

#endif /* __PP_BMC_TP_GPIO_MULTI_ACT_H__ */
