/**
 * tp_i2c_mux.h
 *
 * An abstraction for i2c multiplexer devices.
 * 
 * (c) 2005 Peppercon AG, 6/14/2005, miba@peppercon.de
 */

#ifndef __TP_I2C_MUX_H__
#define __TP_I2C_MUX_H__

#include <pp/vector.h>
#include <pp/bmc/tp_i2c_comdev.h>

/**
 * The abstract i2c mux device driver.
 * Has a pointer to the parent device it is connected to and
 * the number of the channel the mux object is responsible for
 */
typedef struct pp_tp_i2c_mux_s {
    pp_tp_i2c_comdev_t base;

    pp_tp_i2c_comdev_t *parent; /* parent device this mux is connected to */

    unsigned char i2caddr; /* own i2c address */
    u_char channel;        /* downstream channel of the mux device */
    
    int (*switch_channel)(struct pp_tp_i2c_mux_s*);
    int (*disable_channels)(struct pp_tp_i2c_mux_s*);
} pp_tp_i2c_mux_t;


/**
 * PP i2c mux initializer;
 */
void pp_tp_i2c_mux_init(pp_tp_i2c_mux_t* d,
			pp_tp_obj_type_t type,
			const char* id,
			void (*dtor)(pp_tp_obj_t*),
			int (*switch_channel)(pp_tp_i2c_mux_t* d),
			int (*disable_channels)(pp_tp_i2c_mux_t* d),
			pp_tp_i2c_comdev_t *parent,
			u_char i2caddr,
			u_char channel);

/**
 * PP i2c mux cleanup
 */
void pp_tp_i2c_mux_cleanup(pp_tp_i2c_mux_t* d);

#endif
