/**
 * tp_pwm_act.h
 *
 * general PWM actor's functionality
 *
 * (c) 2005 Peppercon AG, 2005/05/24 thomas@peppercon.de
 */

#ifndef _PP_BMC_TP_PWM_ACT_H
#define _PP_BMC_TP_PWM_ACT_H

#include <pp/bmc/tp_actor.h>

typedef enum {
    PP_TP_PWM_DISABLE = 0,
    PP_TP_PWM_MANUAL  = 1,
    PP_TP_PWM_AUTO    = 2,
} pp_tp_pwm_mode_t;

typedef struct pp_tp_pwm_act_s pp_tp_pwm_act_t;

typedef int (*pp_tp_pwm_act_set_mode_func_t)(pp_tp_pwm_act_t*, pp_tp_pwm_mode_t);
typedef int (*pp_tp_pwm_act_get_mode_func_t)(pp_tp_pwm_act_t*, pp_tp_pwm_mode_t*);
typedef int (*pp_tp_pwm_act_set_duty_cycle_func_t)(pp_tp_pwm_act_t*, u_char);
typedef int (*pp_tp_pwm_act_get_duty_cycle_func_t)(pp_tp_pwm_act_t*, u_char*);

struct pp_tp_pwm_act_s {
    pp_tp_actor_t base;
    
    pp_tp_pwm_act_set_mode_func_t set_mode;
    pp_tp_pwm_act_get_mode_func_t get_mode;
    pp_tp_pwm_act_set_duty_cycle_func_t set_duty_cycle;
    pp_tp_pwm_act_get_duty_cycle_func_t get_duty_cycle;
};

/*
 * init / cleanup
 */
static inline int
pp_tp_pwm_act_init(pp_tp_pwm_act_t* this, pp_tp_obj_type_t type,
		   const char* id, pp_tp_obj_dtor_func_t dtor,
		   pp_tp_pwm_act_set_mode_func_t set_mode,
		   pp_tp_pwm_act_get_mode_func_t get_mode,
		   pp_tp_pwm_act_set_duty_cycle_func_t set_duty_cycle,
		   pp_tp_pwm_act_get_duty_cycle_func_t get_duty_cycle)
{
    if (PP_SUCCED(pp_tp_actor_init(&this->base, type, id, dtor))) {
	this->set_mode = set_mode;
	this->get_mode = get_mode;
	this->set_duty_cycle = set_duty_cycle;
	this->get_duty_cycle = get_duty_cycle;
	return PP_SUC;
    }
    return PP_ERR;
}

static inline void
pp_tp_pwm_act_cleanup(pp_tp_pwm_act_t* this)
{
    pp_tp_actor_cleanup(&this->base);
}

/*
 * convinience functions
 */
static inline pp_tp_pwm_act_t*
pp_tp_pwm_act_duplicate(pp_tp_pwm_act_t* this)
{
    return (pp_tp_pwm_act_t*)pp_tp_obj_duplicate((pp_tp_obj_t*)this);
}

static inline void
pp_tp_pwm_act_release(pp_tp_pwm_act_t* this)
{
    pp_tp_obj_release((pp_tp_obj_t*)this);
}

static inline int
pp_tp_pwm_set_mode(pp_tp_pwm_act_t* this, pp_tp_pwm_mode_t mode)
{
    return this->set_mode(this, mode);
}

static inline int
pp_tp_pwm_get_mode(pp_tp_pwm_act_t* this, pp_tp_pwm_mode_t* mode_ptr)
{
    return this->get_mode(this, mode_ptr);
}

static inline int
pp_tp_pwm_set_duty_cycle(pp_tp_pwm_act_t* this, u_char duty_cycle)
{
    return this->set_duty_cycle(this, duty_cycle);
}

static inline int
pp_tp_pwm_get_duty_cycle(pp_tp_pwm_act_t* this, u_char* duty_cycle_ptr)
{
    return this->get_duty_cycle(this, duty_cycle_ptr);
}

#endif /* _PP_BMC_TP_PWM_ACT_H */
