/**
 * tp_sens_has_value_cond.h
 *
 * Condition object taht is true if a sensor has one from
 * a list of specified values
 * 
 * (c) 2005 Peppercon AG, Ronald Wahl <rwa@peppecon.de>
 */

#ifndef _PP_BMC_TP_SENS_HAS_VALUE_COND_H
#define _PP_BMC_TP_SENS_HAS_VALUE_COND_H

#include <pp/bmc/tp_sensdev.h>
#include <pp/bmc/tp_cond.h>

typedef struct {
    pp_tp_cond_t base;
    pp_tp_sensdev_t * sensor;
    pp_tp_sensdev_subscriber_t sens_subscriber;
    vector_t * values;
} pp_tp_sens_has_value_cond_t;

/* ppdoc
 * name:   Sensor has value condition
 * tpname: SensHasValueCond
 * desc:   A condition that is directly derived from (discrete) sensor readings.
 * desc:   The condition will be true if the sensor matches the configured reading.
 * arg 0:  [OBJ(SENS_DEV)] sens: The sensor that this condition is based on.
 * arg 1:  [INT] reading:        The condition will be true if this reading matches
 * arg 1:                        the sensor reading.
 * return: [OBJ(SENS_HAS_VALUE_COND)]
 */
pp_tp_obj_t* pp_tp_sens_has_value_cond_ctor(const char* id, vector_t* args);

void pp_tp_sens_has_value_cond_dtor(pp_tp_obj_t* this);

int pp_tp_sens_has_value_cond_init(pp_tp_sens_has_value_cond_t* this,
				   pp_tp_obj_type_t type,
				   const char * id, pp_tp_obj_dtor_func_t dtor,
				   pp_tp_sensdev_t * sensor,
				   vector_t * values);

void pp_tp_sens_has_value_cond_cleanup(pp_tp_sens_has_value_cond_t* this);

#endif /* _PP_BMC_TP_SENS_HAS_VALUE_COND_H */
