/**
 * tp_sens_subscriber.h
 *
 * The sens_subscriber interface
 * 
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

#ifndef __PP_BMC_TP_SENS_SUBSCRIBER_H__
#define __PP_BMC_TP_SENS_SUBSCRIBER_H__

#include <pp/vector.h>

typedef struct pp_tp_sensdev_s pp_tp_sensdev_t;

typedef struct pp_tp_sensdev_subscriber_s pp_tp_sensdev_subscriber_t;

typedef void (*pp_tp_sensdev_subscriber_recv_reading_func_t)
    (pp_tp_sensdev_subscriber_t * subscriber, pp_tp_sensdev_t * source, int reading);

/**
 * sensor describers defines methods to push 
 * senors reading to them
 */
struct pp_tp_sensdev_subscriber_s {
    /**
     * This function is called by the sensor to push one new sensor
     * reading to the subscriber
     */
    pp_tp_sensdev_subscriber_recv_reading_func_t recv_reading;
};

#endif /* __PP_BMC_TP_SENS_SUBSCRIBER_H__ */
