/**
 * tp_smx_act.h
 *
 * Seriell MUX Actor.
 * The seriell muxer is a platform depended set of switches
 * that allow sharing of the seriell connector between host and BMC
 * and using the BMC's seriell controller for the SOL implementation
 *
 * (c) 2005 Peppercon AG, 2005/05/30, thomas@peppercon.de
 */

#ifndef __PP_TP_SMX_ACT_H__
#define __PP_TP_SMX_ACT_H__

#include <pp/bmc/tp_actor.h>

typedef struct pp_tp_smx_act_s {
    
    pp_tp_actor_t base;

    /* connect chassis seriell connector to MOBO UART */
    int (*switch_host_chassis)(struct pp_tp_smx_act_s* o);

    /* connect chassis seriell connector to BMC UART */
    int (*switch_bmc_chassis)(struct pp_tp_smx_act_s* o);

    /* connect MOBO UART with BMC UART, for SOL
       (this will implicitely also cross signal lines of BMC) */
    int (*switch_host_bmc)(struct pp_tp_smx_act_s* o);
    
} pp_tp_smx_act_t;

/*
 * init / cleanup
 */
static inline void
pp_tp_smx_act_init(pp_tp_smx_act_t* o, pp_tp_obj_type_t type, 
		   const char* id, void (*dtor)(pp_tp_obj_t*),
		   int (*switch_host_chassis)(struct pp_tp_smx_act_s* o),
		   int (*switch_bmc_chassis)(struct pp_tp_smx_act_s* o),
		   int (*switch_host_bmc)(struct pp_tp_smx_act_s* o)) {
    pp_tp_actor_init(&o->base, type, id, dtor);
    o->switch_host_chassis = switch_host_chassis;
    o->switch_bmc_chassis = switch_bmc_chassis;
    o->switch_host_bmc = switch_host_bmc;
}

static inline void pp_tp_smx_act_cleanup(pp_tp_smx_act_t* o) {
    pp_tp_actor_cleanup(&o->base);
}

/* convinience functions */
static inline int pp_tp_smx_switch_host_chassis(struct pp_tp_smx_act_s* o) {
    return o->switch_host_chassis(o);
}

static inline int pp_tp_smx_switch_bmc_chassis(struct pp_tp_smx_act_s* o) {
    return o->switch_bmc_chassis(o);
}

static inline int pp_tp_smx_switch_host_bmc(struct pp_tp_smx_act_s* o) {
    return o->switch_host_bmc(o);
}


#endif /* __PP_TP_SMX_ACT_H__ */
