/**
 * topo_base_obj.c
 *
 * Defines the root topology object.
 *
 * (c) 2005 Peppercon AG, 3/9/2005, tbr@peppecon.de
 */

#include <string.h>
#include <stdlib.h>

#include <pp/base.h>
#include <pp/bmc/topo_base_obj.h>

static const char* obj_to_string(pp_tp_obj_t* this);

/**
 * useful utilities for initializing the base obj
 */
int
pp_tp_obj_init(pp_tp_obj_t* this, pp_tp_obj_type_t type, const char* id,
	       pp_tp_obj_dtor_func_t dtor)
{
    this->type = type;
    this->id = strdup(id);
    this->refcnt = 1;
    this->to_string = obj_to_string;
    this->destroy = dtor;

    return PP_SUC;
}

/**
 * simple default to_string fkt
 */
static const char*
obj_to_string(pp_tp_obj_t* this)
{
    return this->id;
}
