/**
 * topo_parser_test.c
 *
 * simple standalone test of the parser
 * runs through the Topology file, creates all objects and outputs them
 * 
 * (c) 2005 Peppercon AG, 3/9/2005, tbr@peppecon.de
 */

#include <stdio.h>
#include "topo_parser_impl.h"
#include "topo_ctors.h"

static void pp_tp_def_print(pp_tp_def_t* tp);
static void pp_tp_arg_print(pp_tp_arg_t* arg);
static void arg_list_print(arg_list_t* arglist);
static void obj_inst_cb(pp_tp_obj_t* obj);

int main (int argc, char** argv) {

    int ret;
    pp_tp_def_t *tp_def;

    if (argc < 2) {
	printf("%s: specify toplogy description file!\n", argv[0]);
	return 1;
    }
    printf("%s running on %s\n", argv[0], argv[1]);

    if (NULL == (tp_def = pp_tp_parse_topo(argv[1],
					   pp_tp_ctors_basic,
					   pp_tp_ctors_basic_sz))) {
	perror("Parsing failed");
	ret = 1;
    } else {
	printf("finished successfully\n");
	printf("\nPrinting c'tor map =>\n\n");
	pp_tp_def_print(tp_def);
	
	printf("\nInstantiating objects =>\n\n");
	pp_tp_def_incarnate(tp_def, obj_inst_cb);
	
	pp_tp_def_destroy(tp_def);
	ret = 0;
    }
    return ret;
}

static void obj_inst_cb(pp_tp_obj_t* obj) {
    const char* t; 
    if (PP_TP_IS_TYPE(PP_TP_SEN_DEV, obj->type)) {
	t = "PP_TP_SEN_DEV";
    } else if (PP_TP_IS_TYPE(PP_TP_COM_DEV, obj->type)) {
	t = "PP_TP_COM_DEV";
    } else if (PP_TP_IS_TYPE(PP_TP_MISSION, obj->type)) {
	t = "PP_TP_MISSION";
    } else {
	int KNOWN_TYPE = 0;
	assert(KNOWN_TYPE);
    }
    printf("obj: %s (%s)\n", pp_tp_obj_to_string(obj), t);
}

static void pp_tp_def_print(pp_tp_def_t* tp) {
    obj_ctor_t* ctor;

    for (ctor = pp_hash_get_first_entry(tp->ctorsmap); ctor != NULL;
	 ctor = pp_hash_get_next_entry(tp->ctorsmap)) {
	printf("%s (%s) ==>\n", ctor->name, 
	       (CTOR_IS_TEMPLATE(ctor) ? "template" : "object"));
	arg_list_print(ctor->arglist);
    }
}

static void arg_list_print(arg_list_t* al) {
    if (al == NULL) {
	printf("   NO ARGS\n");
    } else {
	vector_t* v = &al->args;
	int i, s = vector_size(v);

	for (i = 0; i < s; i++) {
	    printf("   #%d: ", i);
	    pp_tp_arg_print(vector_get2(v, i));
	    printf("\n");
	}
    }
}

static void pp_tp_arg_print(pp_tp_arg_t* a) {
    switch (a->type) {
      case PP_TP_ARG_STRING:
	  printf("STRING: %s", a->value.string);
	  break;
      case PP_TP_ARG_SYMBOL:
	  printf("SYMBOL: %s", a->value.string);
	  break;
      case PP_TP_ARG_OBJ:
	  printf("OBJ: %p", a->value.obj);
	  break;
      case PP_TP_ARG_INT:
	  printf("INT: %d", a->value.intval);
	  break;
      case PP_TP_ARG_BOOL:
	  printf("BOOL: %s", (a->value.intval ? "true" : "false"));
	  break;
      case PP_TP_ARG_PLACEHOLDER:
	  printf("PLACEHOLDER");
	  break;
      default:
	  assert(0);
    }
}
