/**
 * tp_acpi_power_state.c
 *
 * An abstract ACPI power state sensor.
 * 
 * (c) 2005 Peppercon AG, Ronald Wahl <rwa@peppercon.de>
 */

#include <pp/bmc/bmc_config.h>
#include <pp/bmc/tp_acpi_power_state.h>
#include <pp/bmc/debug.h>
#include <pp/bmc/ipmi_sdr.h>

static ipmi_sdr_header_t* acpi_power_state_default_sdr(pp_tp_sensdev_t* s);

int
pp_tp_acpi_power_state_init(pp_tp_acpi_power_state_t* this,
			    pp_tp_obj_type_t type, const char* id,
			    pp_tp_obj_dtor_func_t dtor)
{
    return pp_tp_sensdev_init(&this->base, type, id, dtor,
			      acpi_power_state_default_sdr);
}

void
pp_tp_acpi_power_state_cleanup(pp_tp_acpi_power_state_t* this)
{
    pp_tp_sensdev_cleanup(&this->base);
}

static ipmi_sdr_header_t*
acpi_power_state_default_sdr(pp_tp_sensdev_t* s UNUSED)
{
    ipmi_sdr_compact_sensor_t* mysdr;

    mysdr = ipmi_sdr_compact_part_create
	(IPMI_SENSOR_TYPE_SYSTEM_ACPI_POWER_STATE,
	 IPMI_EVENT_READING_TYPE_SENSOR_SPECIFIC);

    return (ipmi_sdr_header_t*)mysdr;
}
