/**
 * pp_tp_sensdev.c
 *
 * Abstract sensor device object
 * 
 * (c) 2005 Peppercon AG, 3/9/2005, tbr@peppecon.de
 */

#include <pp/base.h>
#include <pp/bmc/topo_classes.h>
#include <pp/bmc/tp_sensdev.h>

int pp_tp_sensdev_init(pp_tp_sensdev_t* this, pp_tp_obj_type_t type,
		       const char* id, pp_tp_obj_dtor_func_t dtor,
		       pp_tp_sensdev_default_sdr_func_t default_sdr) {
    assert(PP_TP_IS_TYPE(PP_TP_SENS_DEV, type));
    
    pp_tp_obj_init(&this->base, type, id, dtor);
    this->reading = -1; /* reading unavailable */
    this->default_sdr = default_sdr;
    this->subscribers = vector_new(NULL, 0, NULL);

    return PP_SUC;
}

void pp_bmc_tp_sensdev_subscribe(pp_tp_sensdev_t* this,
				 pp_tp_sensdev_subscriber_t* subscriber) {
    assert(PP_TP_OBJ_IS_TYPE(PP_TP_SENS_DEV, this));
    vector_add(this->subscribers, subscriber);
}

int pp_bmc_tp_sensdev_unsubscribe(pp_tp_sensdev_t* this,
			          pp_tp_sensdev_subscriber_t* subscriber) {
    size_t i, vs = vector_size(this->subscribers);

    assert(PP_TP_OBJ_IS_TYPE(PP_TP_SENS_DEV, this));

    for (i = 0; i < vs; ++i) {
        if (subscriber == vector_get(this->subscribers, i)) {
            vector_remove(this->subscribers, i);
            return PP_SUC;
        }
    }
    
    // not found
    return PP_ERR;
}

void pp_bmc_tp_sensdev_notify_subscribers(pp_tp_sensdev_t* this,
					  int new_reading) {
    size_t i;
    pp_tp_sensdev_subscriber_t* subscriber;

    assert(PP_TP_OBJ_IS_TYPE(PP_TP_SENS_DEV, this));
    
    for (i = 0; i < vector_size(this->subscribers); ++i) {
        subscriber = (pp_tp_sensdev_subscriber_t*)vector_get(this->subscribers,i);
        subscriber->recv_reading(subscriber, this, new_reading);
    }
}
