/**
 * serial_adapter.h
 *
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 *
 * A serial port channel adapter for the bmc. This channel
 * currently supports direct connections in basic mode only.
 */

#ifndef __SERIAL_ADAPTER_H__
#define __SERIAL_ADAPTER_H__

/**
 * Add message to serial interface from external code.
 * Used to add the get_channel_capabilites_message to
 * the serial channel after switching there from snooping.
 * This command will overwrite messages in the inbuffer
 * so make sure to call this command immediately after
 * switching the mux.
 */
int pp_bmc_serial_receive_msg(unsigned char* buf, int len);

/**
 * Set the serial channel filedescriptor. This filedescriptor will only be
 * used if a switch from the serial_snoop to serial_adapter takes place.
 * Take care, calling this function while the serial_adapter is activated
 * can mess up internal structures.
 */
void bmc_serial_adapter_set_fd(int serial_fd);

/**
 * Notify the serial adapter that a ping response has been received.
 * Called by serial_modem_cmds.
 */
void bmc_serial_mux_response_received(void);

/** 
 * Init the serial channel adapter
 */
int pp_bmc_serial_init(void);

/** 
 * Cleanup the serial channel adapter
 */
void pp_bmc_serial_cleanup(void);


#endif

