/**
 * smi_adapter.h
 *
 * (c) 2005 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 *
 * Defines the core functionality of the smi adapter.
 * Init one of the concrete SMI adapters.
 */

#ifndef __BMC_SMI_H__
#define __BMC_SMI_H__

// internally used limitation
#define PP_BMC_SMI_MAX_MSG_LEN 1024 // needed for fw uplaod
                                    // openIPMI uses 172 here

/** 
 * Init the smi channel adapter
 */
int pp_bmc_smi_init(void);

/** 
 * Cleanup the smi channel adapter
 */
void pp_bmc_smi_cleanup(void);

typedef enum {
    PP_SMI_MODE_UNKNOWN,
    PP_SMI_MODE_KCS,
    PP_SMI_MODE_BT,
    PP_SMI_MODE_SMIC,
    PP_SMI_MODE_LOOPBACK
} pp_bmc_smi_mode_t;

/** 
 * Get the active SMI mode
 *
 * @return mode of the SMI
 */
pp_bmc_smi_mode_t pp_bmc_smi_get_mode(void);

#endif /* __BMC_SMI_H__ */
