/**
 * ipmi_bmc_si.h
 *
 * (c) 2004 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

#ifndef __LINUX_IPMI_BMC_SI_H
#define __LINUX_IPMI_BMC_SI_H

#include <linux/ioctl.h>

/**
 * This file defines the bmc-internal functions to access the system
 * interface. The device described in this file is not the 'onboard'
 * bmc, but an external system interface that other boards can connect
 * to. Thus these functions should only be used by the peppercon
 * bmc-core.
 */


/**
 * BMC SI msg structure
 */
typedef struct {
	unsigned char *data; /* data field, must be supplied by user */
	int data_size;       /* max. length of data field, will be set to size of data by kernel */
} bmc_si_msg_t;


/* unique IOCTL magic char 'p' for peppercon */
#define IPMI_IOCTL_MAGIC 'p'

/**
 * Invoked by BMC to receive messages through the SI
 */
#define IPMI_BMC_RECEIVE	_IOR(IPMI_IOCTL_MAGIC, 1, bmc_si_msg_t)

/**
 * Send a message (from the BMC to the SI)
 */
#define IPMI_BMC_SEND		_IOW(IPMI_IOCTL_MAGIC, 2, bmc_si_msg_t)

 
#endif /* __LINUX_IPMI_BMC_SI_H */
