/**
 * bmc local test main function
 * 
 * (c) 2004 Peppercon AG, 11/16/2004, tbr@peppecon.de
 */

#include <stdlib.h>
#include <pp/base.h>
#include <pp/selector.h>
#include <pp/cfg.h>
#include <pp/bmc/bmc.h>
#include <pp/bmc/debug.h>

static int stdin_hndl(const int item_id UNUSED, const int fd UNUSED, 
		      const short event UNUSED, void* ctx UNUSED) {
    if (getchar() == 'x') {
	pp_select_interrupt();
    }
    return PP_SUC;
}

int main (int argc UNUSED, char** argv UNUSED) {

    pp_base_init("test", 0);
    #if defined(PP_BMC_LOCAL_TEST)
        if (PP_ERR == pp_cfg_init("base.cdl", NULL)) abort();
    #else
        if (PP_ERR == pp_cfg_init(PP_CD_FNAME_DEFAULT, PP_CD_OEM_SKEL_FNAME_DEFAULT))
					 abort();
    #endif

    pp_bmc_init();
    pp_select_add_fd(0 /* stdin */, POLLIN, stdin_hndl, NULL);
    pp_select_loop();
    
    pp_bmc_cleanup();
    pp_cfg_cleanup();
    pp_base_cleanup();
    return 0;
}
