DEPCOMP		 = depcomp
DEPDIR		 = .deps
INCLUDES	 = -I. -Iinclude $(FW_INCLUDES)
SRCS		:= $(SRCS) $(LIBSRCS) $(PRGSRCS)
LIBOBJS		 = $(sort $(patsubst %.cpp,%.o,$(LIBSRCS:%.c=%.o)))
LIBSHOBJS	 = $(sort $(patsubst %.cpp,%.os,$(LIBSRCS:%.c=%.os)))
PRGOBJS		 = $(sort $(patsubst %.cpp,%.o,$(PRGSRCS:%.c=%.o)))
UTESTOBJS    = $(sort $(patsubst %.cpp,%.o,$(UTESTSRCS:%.c=%.o)))
PICFLAG		 = -fPIC
CFLAGS		+= $(FW_CFLAGS)
CXXFLAGS	+= $(FW_CXXFLAGS)
ifeq ($(DISABLE_WERROR), 1)
CFLAGS		+= -Wno-error
CFLAGS_SPEED	+= -Wno-error
CXXFLAGS	+= -Wno-error
endif
LDFLAGS		+= $(FW_LDFLAGS) $(shell if test -e $(LIB_NAME).ver; then echo "-Wl,--version-script,./$(LIB_NAME).ver"; fi)
XGTFLAGS	+= --keyword=_  --keyword=N_ --force-po 
TRANSSRCS	+= $(SRCS)

ifneq "$(strip $(SHARED_LIB))" ""
TRANSLATION	= $(LIB_NAME).pot
endif
ifneq "$(strip $(STATIC_LIB))" ""
TRANSLATION	= $(LIB_NAME).pot
endif
ifneq "$(strip $(PRG))" ""
TRANSLATION	= $(PRG).pot
endif


all install all-recursive install-recursive clean clean-recursive: 
	@target=`echo $@ | sed s/-recursive//`; \
	[ "$$target" != "clean" ] && { $(MAKE) prepare-local || exit $?; }; \
	list='$(SUBDIRS)'; for subdir in $$list; do \
	  $(MAKE) -C $$subdir $@ || exit $?; \
	done; \
	$(MAKE) $$target-local || exit $?; \
	[ "$$target" != "clean" ] && { $(MAKE) fixme_check || exit $?; } || :

prepare-local::

all-local:: $(LINKFILES) $(STATIC_LIB) $(SHARED_LIB) $(PRG) $(UTESTPRG) translation

install-local:: all-local
ifneq "$(strip $(SHARED_LIB))" ""
	$(INSTALL) -d -m 755 $(DESTDIR)$(LIBDIR)
	$(INSTALL) -m 755 $(SHARED_LIB) $(DESTDIR)$(LIBDIR)/
	rm -f $(DESTDIR)$(LIBDIR)/$(LIB_NAME).so.$(SHARED_LIB_MAJOR)
	rm -f $(DESTDIR)$(LIBDIR)/$(LIB_NAME).so
	ln -s $(SHARED_LIB) $(DESTDIR)$(LIBDIR)/$(LIB_NAME).so.$(SHARED_LIB_MAJOR)
	ln -s $(SHARED_LIB) $(DESTDIR)$(LIBDIR)/$(LIB_NAME).so
endif
ifneq "$(strip $(STATIC_LIB))" ""
	$(INSTALL) -d -m 755 $(DESTDIR)$(LIBDIR)
	$(INSTALL) -m 644 $(STATIC_LIB) $(DESTDIR)$(LIBDIR)/
endif
ifneq "$(strip $(PRG))" ""
	$(INSTALL) -d -m 755 $(DESTDIR)$(BINDIR)
	$(INSTALL) -m 755 $(PRG) $(DESTDIR)$(BINDIR)/
endif
ifneq "$(strip $(UTESTPRG))" ""
	$(INSTALL) -d -m 755 $(DESTDIR)$(UTESTDIR)
	$(INSTALL) -m 755 $(UTESTPRG) $(DESTDIR)$(UTESTDIR)/
endif
ifneq "$(strip $(TRANSLATION))" ""
	cp -f $(TRANSLATION) $(TRANSLATIONTEMPDIR)
endif

clean-local::
	if [ -d "$(DEPDIR)" -a "$(DEPDIR)" != "/" ]; then \
	    rm -rf $(DEPDIR); \
	fi
	rm -f *~ *.o *.os *.a *.so* *.pot $(LIBOBJS) $(LIBSHOBJS) $(PRGOBJS) $(LINKFILES) $(PRG) $(UTESTPRG)
ifneq "$(strip $(STATIC_LIB))" ""
	rm -f $(DESTDIR)$(LIBDIR)/$(STATIC_LIB)
endif

ifneq "$(strip $(STATIC_LIB))" ""
$(STATIC_LIB): $(LIBOBJS)
	rm -f '$@'
	$(AR) r '$@' $(LIBOBJS)
	$(RANLIB) '$@'
endif

ifneq "$(strip $(SHARED_LIB))" ""
$(SHARED_LIB): $(LIBSHOBJS) $(DEPLIBS)
	$(CC) $(LDFLAGS) -shared $(LIBSHOBJS) -o '$@' -Wl,-soname,$(LIB_NAME).so.$(SHARED_LIB_MAJOR) $(LIBS)
endif

ifneq "$(strip $(PRG))" ""
LINK_NEEDED = yes
endif

ifneq "$(strip $(UTESTPRG))" ""
LINK_NEEDED = yes
endif

ifeq ($(LINK_NEEDED),yes)
LINK ?= $(CC)
ifneq ($(PP_PRODUCT),ccf)
LDFLAGS += -Wl,--gc-sections
endif
ifneq "$(strip $(PRG))" ""
$(PRG): $(PRGOBJS) $(DEPLIBS)
	$(LINK) $(LDFLAGS) $(PRGOBJS) $(PRGEXTRAOBJS) -o '$@' $(LIBS)
endif
ifneq "$(strip $(UTESTPRG))" ""
$(UTESTPRG): $(UTESTOBJS) $(DEPLIBS)
	$(LINK) $(LDFLAGS) $(UTESTOBJS) $(UTESTEXTRAOBJS) -o '$@' $(LIBS)
endif
endif

translation:
ifneq "$(strip $(TRANSLATION))" ""
	$(XGT) $(XGTFLAGS) -o '$(TRANSLATION)' $(TRANSSRCS)
endif

DEPMODE=gcc3

$(DEPDIR)/%.Po: %.c Makefile
	@if [ ! -d '$(DEPDIR)' ]; then mkdir '$(DEPDIR)'; fi
	@dir="`dirname '$(DEPDIR)/$*'`"; \
	if [ ! -d "$$dir" ]; then mkdir -p "$$dir"; fi
	@if [ ! -r '$@' ]; then touch '$@'; fi

$(DEPDIR)/%.Po: %.cpp Makefile
	@if [ ! -d '$(DEPDIR)' ]; then mkdir '$(DEPDIR)'; fi
	@dir="`dirname '$(DEPDIR)/$*'`"; \
	if [ ! -d "$$dir" ]; then mkdir -p "$$dir"; fi
	@if [ ! -r '$@' ]; then touch '$@'; fi

%.o: %.c Makefile
	@if [ ! -d '$(DEPDIR)' ]; then mkdir '$(DEPDIR)'; fi
	source='$<' object='$@' libtool=no \
	depfile='$(DEPDIR)/$*.Po' tmpdepfile='$(DEPDIR)/$*.Tpo' \
	depmode=$(DEPMODE) \
	$(DEPCOMP) $(CC) $(CFLAGS) $(INCLUDES) -c $< -o $@

%.o: %.cpp Makefile
	@if [ ! -d '$(DEPDIR)' ]; then mkdir '$(DEPDIR)'; fi
	source='$<' object='$@' libtool=no \
	depfile='$(DEPDIR)/$*.Po' tmpdepfile='$(DEPDIR)/$*.Tpo' \
	depmode=$(DEPMODE) \
	$(DEPCOMP) $(CXX) $(CXXFLAGS) $(INCLUDES) -c $< -o $@

%.os: %.c Makefile
	@if [ ! -d '$(DEPDIR)' ]; then mkdir '$(DEPDIR)'; fi
	source='$<' object='$@' libtool=no \
	depfile='$(DEPDIR)/$*.Po' tmpdepfile='$(DEPDIR)/$*.Tpo' \
	depmode=$(DEPMODE) \
	$(DEPCOMP) $(CC) $(PICFLAG) $(CFLAGS) $(INCLUDES) -c $< -o $@

%.os: %.cpp Makefile
	@if [ ! -d '$(DEPDIR)' ]; then mkdir '$(DEPDIR)'; fi
	source='$<' object='$@' libtool=no \
	depfile='$(DEPDIR)/$*.Po' tmpdepfile='$(DEPDIR)/$*.Tpo' \
	depmode=$(DEPMODE) \
	$(DEPCOMP) $(CXX) $(PICFLAG) $(CXXFLAGS) $(INCLUDES) -c $< -o $@

ifneq "$(strip $(SRCS))" ""
ifneq ($(MAKECMDGOALS),clean)
ifneq ($(MAKECMDGOALS),clean-local)
-include $(patsubst %.cpp,.deps/%.Po,$(SRCS:%.c=.deps/%.Po))
endif
endif
endif

include $(FW_TOPDIR)/build_sys/Check.mk
# for local definitions, e.g. additional debug CFLAGS
-include $(FW_TOPDIR)/local.mk
