# !/usr/bin/env python
# -*- coding: ISO8859-15 -*-
#
# (C) 2004-2005 Peppercon AG, Zwickau (Sachs)
# Frank Hofmann <fho@peppercon.de>
#
# docbook optimizer
# Python script to update picture extensions
#
# updated 2005-09-15
#
# libraries and modules
import xml.dom.minidom
import xml.dom
import sys
import string
import os
import re

import standard

def shellCommandGeneric (program, outputDirectory, filename, newFilename):
	if (program == "dia"):
		return shellCommandDia (outputDirectory, filename, newFilename)

	if (program == "convert"):
		return shellCommandConvert (outputDirectory, filename, newFilename)

	if (program == "fig2dev"):
		return shellCommandFig2Dev (outputDirectory, filename, newFilename)

def shellCommandDia (outputDirectory, filename, newFilename):
	command = "dia -e " + outputDirectory + "/" + newFilename + " " + outputDirectory + "/" + filename + "\n"
	return command

def shellCommandConvert (outputDirectory, filename, newFilename):
	command = "convert " + outputDirectory + "/" + filename + " " + outputDirectory + "/" + newFilename + "\n"
	return command

def shellCommandFig2Dev (outputDirectory, filename, newFilename):
	outputFormat = newFilename[-3:]		# get last 3 characters as file extension
	nameWithoutExtension = newFilename[:-3]
	command = "fig2dev -L eps " + outputDirectory + "/" + filename + " " + outputDirectory + "/" + nameWithoutExtension + "eps"
	if(outputFormat=="png"):
		additionalCommand = shellCommandConvert (outputDirectory, nameWithoutExtension + "eps", newFilename)
		command = command + " | " + additionalCommand
	return command

# init global variables
outputFormat = ""

# read and verify parameters --------------------
inputFile = sys.argv[1]
outputFile = sys.argv[2]
outputFormat = sys.argv[3]
convertListFile = sys.argv[4]
figureListFile = sys.argv[5]
outputDirectory = sys.argv[6]

# init convertList
convertList = []
figureList = []

# set default image file converter
defaultImageConverter = "convert"

print "output format: " + outputFormat
print "reading input file: " + inputFile
inputFileContentArray = standard.readFileContent (inputFile)
inputFileContentString = standard.convertArray2String (inputFileContentArray)

# assume same output without changes
outputFileContentString = inputFileContentString

# set of regular expressions
# - image data reference
regExpImageData = re.compile('<imagedata(\s*\w+=\".*\")*/>', re.UNICODE)
# - file reference
regExpFilename = re.compile('fileref=\"([\w\.\d_\-]+)\"', re.UNICODE)
# - image format
regExpFormat = re.compile('format=\"(\w+)\"', re.UNICODE)

# - images to be converted into eps
regExpEps_filename = re.compile('((png)|(jpg)|(jpeg)|(gif)|(dia)|(fig))$', re.UNICODE | re.IGNORECASE)
regExpEps_format = re.compile('((PNG)|(JPG)|(JPEG)|(GIF)|(DIA)|(FIG))', re.UNICODE | re.IGNORECASE)

# - images to be converted into png (for PDF)
regExpPdf_filename = re.compile('((eps)|(jpg)|(jpeg)|(gif)|(dia)|(fig))$', re.UNICODE | re.IGNORECASE)
regExpPdf_format = re.compile('((EPS)|(JPG)|(JPEG)|(GIF)|(DIA)|(FIG))', re.UNICODE | re.IGNORECASE)

# - images to be converted into png (for html)
regExpHtml_filename = re.compile('((eps)|(dia)|(fig))$', re.UNICODE | re.IGNORECASE)
regExpHtml_format = re.compile('((EPS)|(DIA)|(FIG))', re.UNICODE | re.IGNORECASE)

# - images to be converted into png (for rtf)
regExpRtf_filename = re.compile('((jpg)|(jpeg)|(eps)|(gif)|(dia)|(fig))$', re.UNICODE | re.IGNORECASE)
regExpRtf_format = re.compile('((EPS)|(JPG)|(JPEG)|(GIF)|(DIA)|(FIG))', re.UNICODE | re.IGNORECASE)

# - fig files
regExpFig = re.compile('fig$', re.UNICODE | re.IGNORECASE)
# - dia files
regExpDia = re.compile('dia$', re.UNICODE | re.IGNORECASE)

imageReferences = re.findall(regExpImageData, inputFileContentString)
for entry in imageReferences:
	oldEntry = entry
	imageFilename = re.findall(regExpFilename, entry)
	imageFormat = re.findall(regExpFormat, entry)
	oldFilename = imageFilename[0]
	oldFormat = imageFormat[0]
	newFilename = oldFilename
	pictureConverter = defaultImageConverter
	print "checking: ", oldFilename

	if outputFormat in ["ps", "dvi", "tex"]:
		# transform to eps if needed
		if re.search(regExpEps_filename, oldFilename):
			if re.search(regExpDia, oldFilename): pictureConverter = "dia"
			if re.search(regExpFig, oldFilename): pictureConverter = "fig2dev"
							
			newFilename = re.sub(regExpEps_filename, "eps", oldFilename)
			entry = re.sub(oldFilename, newFilename, entry)
	
			newFormat = re.sub(regExpEps_format, "EPS", oldFormat)
			entry = re.sub(oldFormat, newFormat, entry)
	
			# update list of files to be converted later on, actually
			# add full command line depending on the picture format
			appendLine = shellCommandGeneric (pictureConverter, outputDirectory, oldFilename, newFilename)
			convertList.append(appendLine)
			
		if outputFormat in ["tex","dvi"]:
			figureList.append(outputDirectory + "/" + newFilename + "\n")
		
		print "[", outputFormat, "] From ", oldFilename, " to ", newFilename, " using ", pictureConverter

	if outputFormat in ["pdf"]:
		# transform to png
		if re.search(regExpPdf_filename, oldFilename):
			if re.search(regExpDia, oldFilename): pictureConverter = "dia"
			if re.search(regExpFig, oldFilename): pictureConverter = "fig2dev"
						
			newFilename = re.sub(regExpPdf_filename, "png", oldFilename)
			entry = re.sub(oldFilename, newFilename, entry)

			newFormat = re.sub(regExpPdf_format, "PNG", oldFormat)
			entry = re.sub(oldFormat, newFormat, entry)
							
			# update list of files to be converted later on, actually
			# add full command line depending on the picture format
			appendLine = shellCommandGeneric (pictureConverter, outputDirectory, oldFilename, newFilename)
			convertList.append(appendLine)
			print "[", outputFormat, "] From ", oldFilename, " to ", newFilename, " using ", pictureConverter
	
	if outputFormat in ["html"]:
		# transform to png
		if re.search(regExpHtml_filename, oldFilename):
			if re.search(regExpDia, oldFilename): pictureConverter = "dia"
			if re.search(regExpFig, oldFilename): pictureConverter = "fig2dev"

			newFilename = re.sub(regExpHtml_filename, "png", oldFilename)
			entry = re.sub(oldFilename, newFilename, entry)

			newFormat = re.sub(regExpHtml_format, "PNG", oldFormat)
			entry = re.sub(oldFormat, newFormat, entry)
			# update list of files to be converted later on, actually
			# add full command line depending on the picture format
			appendLine = shellCommandGeneric (pictureConverter, outputDirectory, oldFilename, newFilename)
			convertList.append(appendLine)
			print "[", outputFormat, "] From ", oldFilename, " to ", newFilename, " using ", pictureConverter
		else:
			figureList.append(outputDirectory + "/" + oldFilename + "\n")

	if outputFormat in ["rtf"]:
		# transform to png
		if re.search(regExpRtf_filename, oldFilename):
			newFilename = re.sub(regExpRtf_filename, "png", oldFilename)
			entry = re.sub(oldFilename, newFilename, entry)
	
			newFormat = re.sub(regExpRtf_format, "PNG", oldFormat)
			entry = re.sub(oldFormat, newFormat, entry)
	
			# update list of files to be converted later on, actually
			# add full command line depending on the picture format
			appendLine = shellCommandGeneric (pictureConverter, outputDirectory, oldFilename, newFilename)
			convertList.append(appendLine)
	
		figureList.append(outputDirectory + "/" + newFilename + "\n")
		print "[", outputFormat, "] From ", oldFilename, " to ", newFilename, " using ", pictureConverter

	# do final substitution in the output data stream
	outputFileContentString = re.sub(oldEntry, entry, outputFileContentString)

outputFileContentArray = [outputFileContentString]

# save output file ------------------------------
if standard.saveFileContent (outputFile, outputFileContentArray) == 0:
	print "... new content saved to output file."
else:
	print "Cannot save output to file ", outputFile
	sys.exit(1)

if standard.saveFileContent (convertListFile, convertList) == 0:
	print "... saved list of image files to be converted."
else:
	print "Cannot save list of image files to be converted. ", convertListFile
	sys.exit(2)

if standard.saveFileContent (figureListFile, figureList) == 0:
	print "... saved list of figure files to be converted."
else:
	print "Cannot save list of figure files ", figureListFile
	sys.exit(18)


