# !/usr/bin/env python
# -*- coding: ISO8859-15 -*-
#
# -------------------------------------------------
# standard i/o module
#
# (C) 2004-05 Peppercon AG, Zwickau (Sachs)
# email fho@peppercon.de
# -------------------------------------------------

def dtcEncodingStyle ():
	"defines the unicode encoding style"

	return "iso-8859-15"

def decodeLine (line, encoding):
	"converts from one encoding style into unicode"
	newLine = line.decode(encoding)
	return newLine
	
def decodeArray (content, encoding):
	"converts from one encoding style into unicode"

	newContent = []
	for line in content:
		newContent.append(decodeLine(line, encoding))
		
	return newContent

def encodeLine (line, newEncoding):
	"converts from unicode into the given encoding style"
	#print "[ " + newEncoding + " ] from: " + line
	newLine = line.encode(newEncoding)
	#print " to: " + newLine
	return newLine
	
def encodeArray (content, newEncoding):
	"converts from unicode into the given encoding style"
	print "[ " + newEncoding + " ]"

	newContent = []
	for line in content:
		newContent.append(encodeLine(line, newEncoding))

	return newContent

def convertArray2String (arrayData):
	"transforms an array into a single-line string"
	newData = ""
	for line in arrayData:
		newData += line
		
	return newData

def readFileContent (filename):
	"reads given file and return its content"
	
	try:
		fileId = open(filename, "r")
		fileContents = fileId.readlines()
		fileId.close()
	except:
		print "Cannot open given file: ", filename
		# return an empty list
		fileContents = []
	
	return fileContents

def saveFileContent (filename, content):
	"saves content in the given file"

	try:
		fileId = open(filename, "w")
		fileId.writelines(content)
		fileId.close()
		return 0
	except Exception, a:
		print a
		return -1

def appendFileContent (currentContent, newContent):
	"appends content to a given file"

	outputFileContent = currentContent

	for line in newContent:
		outputFileContent.append(line)

	return outputFileContent

