#! /bin/sh

source ../Config.sh

retval=0

# find all libraries used by binaries
# NOTE: dlopened libraries are not covered by this! This must be done manually.
LIBS=`find bin sbin usr/bin usr/sbin -perm 755 -exec ${CROSS}readelf -d {} \; 2>/dev/null | grep NEEDED | sed -e 's,.*\[\([^]]*\)\].*,\1,' | sort -u`

# recursive find requirements of these libraries
while [ -n "$LIBS" ]; do
    _LIBS="$LIBS"
    LIBS=
    for lib in $_LIBS; do
	if [ -f "lib/$lib" ]; then
	    lib_path="lib/$lib"
	elif [ -f "usr/lib/$lib" ]; then
	    lib_path="usr/lib/$lib"
	else
	    echo "$0: '$lib' not found" >&2
	    retval=1
	fi

	canon_pwd="`readlink -f $PWD`"
	lib_canon_path="`readlink -f $lib_path`"
	lib_canon_path=${lib_canon_path#${canon_pwd}/}
	if [ -z "$lib_canon_path" ]; then
	    echo "$0: '$lib_path' seems to be a dangeling symlink" >&2
	    retval=1
	elif [ "$lib_path" = "$lib_canon_path" ]; then
	    USED_LIBS="$USED_LIBS $lib_path"
	else
	    USED_LIBS="$USED_LIBS $lib_path $lib_canon_path"
	fi

	needed_libs="`${CROSS}readelf -d {} \; 2>/dev/null | grep NEEDED | sed -e 's,.*\[\([^]]*\)\].*,\1,'`"
	[ -n "$needed_libs" ] && LIBS="$LIBS $needed_libs"
    done
done

[ $retval -ne 0 ] && exit $retval

( LIBS=`find lib usr/lib -name "*.so*" 2>/dev/null`
  for lib in $LIBS; do
      for used_lib in $USED_LIBS; do
	  [ "$lib" = "$used_lib" ] && continue 2
      done
      echo $lib
  done
) | sort -u

exit 0
