#!/bin/sh

echo "Checking system for fwbase compatibility:"

# selinux?
echo -n "- SELinux not set to Enforcing: "
if [ ! -x /usr/sbin/getenforce ]; then
    echo && echo "not a correctly installed FC5 (getenforce of package libselinux missing"
    exit 1
fi
selinuxsetting=`/usr/sbin/getenforce`
if [ "$selinuxsetting" != "Enforcing" ]; then
    echo "ok"
else
    echo "NO"
    echo "please fix by using 'System/Administration/Security Level and Firewall'"
fi

# tftpboot existing and writeable?
echo -n "- /tftpboot directory: "
if [ -w "/tftpboot" ]; then
   echo "ok"
else
    echo "NO"
    echo "/tftpboot doesn't exists or isn't writeable, please set perm to 1777"
fi

# check whether a firewall is enabled
echo -n "- firewall disabled: "
grep enable /etc/sysconfig/system-config-securitylevel &>/dev/null
if [ "$?" = "0" ]; then
    echo "NO"
    echo "you should disbled the firewall using: 'System/Administration/Security Level and Firewall'"
else
    echo "ok"
fi

# check whether ccache is installed
echo -n "- ccache installed: "
rpm -q ccache &>/dev/null
if [ "$?" = "0" ]; then
    echo "ok"
else
    echo "NO"
    echo "please install ccache using 'yum install ccache'"
fi

# check for some more parts of our toolchain
echo -n "- check for missing packages: "
pack=`rpm -q yyy-pp001-binutils-i586-linux-uclibc \
yyy-pp001-kernheaders-i586-linux-uclibc \
yyy-pp001-gcc-avr-none \
yyy-pp001-uClibc-i586-linux-uclibc \
yyy-pp001-gcc-i586-linux-uclibc \
yyy-pp001-avr-libc-avr-none \
yyy-pp001-j2sdk \
yyy-pp001-kernheaders-armv4-linux-uclibc \
yyy-pp001-binutils-armv4-linux-uclibc \
yyy-pp001-gdb-armv4-linux-uclibc \
yyy-pp001-gcc-powerpc-linux-uclibc \
yyy-pp001-gcc-c++-powerpc-linux-uclibc \
yyy-pp001-gcc-common \
yyy-pp001-gdb-i586-linux-uclibc \
yyy-pp001-uClibc-armv4-linux-uclibc \
yyy-pp001-gcc-armv4-linux-uclibc \
yyy-pp001-gdb-powerpc-linux-uclibc \
yyy-pp001-gcc-c++-i586-linux-uclibc \
yyy-pp001-uClibc-powerpc-linux-uclibc \
yyy-pp001-binutils-avr-none \
yyy-pp001-binutils-powerpc-linux-uclibc \
yyy-pp001-gcc-c++-armv4-linux-uclibc \
yyy-pp001-kernheaders-powerpc-linux-uclibc \
gettext-devel \
| grep 'not installed'`
if [ "$?" = "0" ]; then
    echo "NO"
    echo "please install the missing packages:"
    echo $pack
else
    echo "ok"
fi


