/**
 * dmtf.h
 *
 * Broadcom's Universal Management Protocol
 *
 * (c) 2005 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __DMTF_H__
#define __DMTF_H__

typedef struct dmtf_data dmtf_data_t; // private dmtf data

dmtf_data_t* dmtf_open(const char* intf_name);

int dmtf_close(dmtf_data_t* dmtf);

int dmtf_cmd_set_seq_no(dmtf_data_t* dmtf, unsigned short seq_no, unsigned long aen_req_bits);

typedef struct {
    char name[13];
    unsigned char ver[4];
    unsigned short did;
    unsigned short vid;
    unsigned short sdid;
    unsigned short svid;
} dmtf_ver_id_t;
int dmtf_cmd_get_ver_id(dmtf_data_t* dmtf, dmtf_ver_id_t* ver_id);

typedef struct {
    unsigned char mac1[6];
    unsigned char mac2[6];
    unsigned long vlan;
    unsigned long link;
    unsigned long filter;
    unsigned long flags;
    unsigned char host_mac[6];
} dmtf_params_t;
int dmtf_cmd_get_params(dmtf_data_t* dmtf, dmtf_params_t* params);

typedef struct {
    unsigned long cnt[39];
} dmtf_pkt_stats_t;
int dmtf_cmd_get_pkt_stats(dmtf_data_t* dmtf, dmtf_pkt_stats_t* pkt_stats);

typedef struct {
    unsigned long link; // TODO: could be an bitfield
    unsigned long other;
} dmtf_link_stat_t;
int dmtf_cmd_get_link_stat(dmtf_data_t* dmtf, dmtf_link_stat_t* link_stat);

int dmtf_cmd_enable_chan(dmtf_data_t* dmtf);

int dmtf_cmd_disable_chan(dmtf_data_t* dmtf);

int dmtf_cmd_reset_chan(dmtf_data_t* dmtf);

int dmtf_cmd_set_mac(dmtf_data_t* dmtf, unsigned char* mac, unsigned char addr);

int dmtf_cmd_clr_mac(dmtf_data_t* dmtf, unsigned char addr);

typedef struct {
    unsigned long cnt[19];
} dmtf_stats_t;
int dmtf_cmd_get_dmtf_stats(dmtf_data_t* dmtf, dmtf_stats_t* dmtf_stats);

#endif /* !__DMTF_H__ */
