/**
 * dmtf-test.c
 *
 * Test program for Intel's DMTF
 *
 * (c) 2005 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
//#include <sys/types.h>
//#include <sys/socket.h>
//#include <sys/ioctl.h>
//#include <netpacket/packet.h>
//#include <net/ethernet.h>
//#include <net/if.h>
//#include <linux/sockios.h>

#include "dmtf.h"
#include "hex_dump.h"
#include "../../include/pp/base.h"

/*
static const char*
bin(unsigned long v)
{
    int i;
    static char s[33];
    for (i = 0; i < 32; i++) s[i] = v & (1 << (31 - i)) ? '1' : '0';
    s[32] = '\0';
    return s;
}
*/

/*
void test()
{
    socket s = socket(PF_PACKET, SOCK_RAW, htons(ETH_P_BROADCOM));
    if (s == -1) {
        printf("ERROR: socket() failed: %s (%d)\n", strerror(errno), errno);
        goto fail;
    }

    unsigned short buf[DMTF_MAX_PKT_SIZE / 2] = {
        0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x8874, 0x0101,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0xfffc, 0x768E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    };

    size_t sz = sizeof(buf);
    struct sockaddr_ll addr;
    addr.sll_family     = AF_PACKET;
    addr.sll_protocol   = htons(ETH_P_BROADCOM);
    addr.sll_ifindex    = if_nametoindex("eth1");
    addr.sll_hatype     = 0;
    addr.sll_pkttype    = 0;
    addr.sll_halen      = 6;
    memset(addr.sll_addr, 0xff, 6);
    res = sendto(s, buf, sz, 0, (struct sockaddr*)&addr, sizeof(addr));

    size_t addr_len = sizeof(addr);
    res = recvfrom(s, buf, DMTF_MAX_PKT_SIZE, 0, (struct sockaddr*)&addr, &addr_len);

fail:
}
*/

int main(int argc __attribute__((unused)), char *argv[] __attribute__((unused)))
{
    dmtf_data_t *dmtf = dmtf_open("eth1");
    if (!dmtf) {
        printf("ERROR: dmtf_open() failed\n");
        goto fail;
    }

    dmtf_ver_id_t vid;
    dmtf_cmd_get_ver_id(dmtf, &vid);
    printf("________________________________VER ID\n");
    printf("Firmware: %.12s\n", vid.name);
    printf("Version: %d.%d.%d.%d\n", vid.ver[0], vid.ver[1], vid.ver[2], vid.ver[3]);
    printf("PCI DID/VID/SDID/SVID: %04x/%04x/%04x/%04x\n", vid.did, vid.vid, vid.sdid, vid.svid);

    dmtf_params_t p;
    dmtf_cmd_get_params(dmtf, &p);
    printf("________________________________PARAMS\n");
    printf("MAC 1: %.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n",
            p.mac1[0], p.mac1[1], p.mac1[2], p.mac1[3], p.mac1[4], p.mac1[5]);
    printf("MAC 2: %.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n",
            p.mac2[0], p.mac2[1], p.mac2[2], p.mac2[3], p.mac2[4], p.mac2[5]);
    printf("VLAN Tag: %.8lx\n", p.vlan);
    printf("Link Settings: %.8lx\n", p.link);
    printf("Bcast Filter: %.8lx\n", p.filter);
    printf("Flags: %.8lx\n", p.flags);
    //printf("Host MAC: %.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n",
    //        p.host_mac[0], p.host_mac[1], p.host_mac[2], p.host_mac[3], p.host_mac[4], p.host_mac[5]);

    dmtf_link_stat_t ls;
    dmtf_cmd_get_link_stat(dmtf, &ls);
    printf("________________________________LINK STATUS\n");
    printf("Link Status: 0x%.8lx\n", ls.link);
    printf("Others:      0x%.8lx\n", ls.other);

    dmtf_stats_t s;
    dmtf_cmd_get_dmtf_stats(dmtf, &s);
    printf("________________________________dmtf STATISTICS\n");
    printf("dmtf_cmds_recvd = %ld\n", s.cnt[0]);
    printf("dmtf_cmds_dropped = %ld\n", s.cnt[1]);
    printf("dmtf_seq_no_errs = %ld\n", s.cnt[2]);
    printf("dmtf_chan_id_errs = %ld\n", s.cnt[3]);
    printf("dmtf_cmd_type_errs = %ld\n", s.cnt[4]);
    printf("dmtf_cmd_chksum_errs = %ld\n", s.cnt[5]);
    printf("dmtf_undersized_errs = %ld\n", s.cnt[6]);
    printf("dmtf_oversized_errs = %ld\n", s.cnt[7]);
    printf("dmtf_recv_events = %ld\n", s.cnt[8]);

    dmtf_pkt_stats_t ps;
    dmtf_cmd_get_pkt_stats(dmtf, &ps);
    printf("________________________________PKT STATISTICS\n");
    printf("total bytes received    = %ld\n", ps.cnt[0]);
    printf("total bytes transmitted = %ld\n", ps.cnt[1]);

    unsigned char mac[] = { 0x88, 0x88, 0x88, 0x88, 0x88, 0x88 };
    dmtf_cmd_set_mac(dmtf, mac, 1);

    dmtf_cmd_enable_chan(dmtf);
    // fall through
fail:
    if (dmtf) dmtf_close(dmtf);
    return 0;
}
