/**
 * log.h
 *
 * Logging macros for user space code
 *
 * (c) 2006 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 *
 * Needs following pre-defines:
 * - NAME: name of logging module, will precede the log messages
 * - LOG_COLORED: colored logging (if defined)
 * - LOG_DBG: do DBG logging (if defined), supress DBG if not defined
 */

#ifndef __LOG_H__
#define __LOG_H__

#ifdef NAME
#define PREFIX NAME ": "
#else
#define PREFIX
#endif

#ifdef LOG_COLORED
#define COLOR(b, c) "\x1b[" b ";3" c "m"
#else
#define COLOR(b, c)
#endif

#define BLACK   "0"
#define RED     "1"
#define GREEN   "2"
#define YELLOW  "3"
#define BLUE    "4"
#define MAGENTA "5"
#define CYAN    "6"
#define WHITE   "7"
#define DK      "0"
#define LT      "1"

#define CERR    COLOR(DK, RED)
#define CWARN   COLOR(DK, YELLOW)
#define CINFO   COLOR(DK, GREEN)
#define CDBG    COLOR(LT, BLACK) // dark gray
#define CNORM   "\x1b[0m"

#define ERR(format, args...)    printf(PREFIX CERR  "ERR  " format CNORM "\n", ##args)
#define WARN(format, args...)   printf(PREFIX CWARN "WARN " format CNORM "\n", ##args)
#define INFO(format, args...)   printf(PREFIX CINFO "INFO " format CNORM "\n", ##args)
#if defined(NDEBUG) || !defined(LOG_DBG)
#define DBG(format, args...)
#else
#define DBG(format, args...)    printf(PREFIX CDBG  "DBG  " format CNORM "\n", ##args)
#endif

#endif // __LOG_H__
