#!/usr/bin/perl -w
######################################################################
#
# eric web form parameter extractor
#
# $Id: fmparaex.pl,v 1.2 2005-04-21 11:59:33 rwa Exp $
#

use strict;
my $usage =
  "Usage:\n\n fmparaex.pl <template file> <webs src dir>\n\n".
  "   Example: fmparaex.pl forms-lara.txt ../liberic_webs/src\n".
  "   takes a template file and searches for the template\n".
  "   replacement construct\n".
  "     <param_extract:file-name>\n".
  "   in case this tag is found file-name is opene in the\n".
  "   specified dir and the parameter extraction function will\n".
  "   be called and replace the tag\n";

sub param_extract ( $$$ );
sub dir_file_extract ( $ );
sub get_spaces ( $ );
sub get_config_sh_var($);

my $cpp_flags = get_config_sh_var("FW_CPPFLAGS");
my $fw_topdir = get_config_sh_var("FW_TOPDIR");

($fw_topdir ne "") or die $0.": cannot read config variables, please call me from eric_firmware/doc/oem\n";

($#ARGV == 1) or die $0.": one or more parameters missing!\n\n".$usage;

open TEMPL, $ARGV[0] or die $0.": Can't open $ARGV[0] ($!)!\n";

# scan template and look for tags
while (my $line = <TEMPL>) {
    print $line;
}
print "\n\n";
dir_file_extract ($ARGV[1]);

close TEMPL;
exit 0;

sub dir_file_extract ( $ ) {
   my $dir = shift;
   my $file;
   my @file_list = ();
   opendir(DIR, $dir) or die "Unable to open $dir $!";
   while (defined($file = readdir DIR) ) {
     if (substr($file,0) =~ /tmpl_.*\.c$/ )  {
	
	push(@file_list,$file);
     }
   }
   closedir(DIR);

   #sort array alphabetically
   @file_list = sort {$a cmp $b} @file_list;
   
   foreach $file (@file_list) {
   
	my $result = param_extract ("$dir/$file", 1, 4);
	if ($result ne "") {
	    print "$file\n";
	    print "--------\n";
	    print "$result\n"; 
	}    
     }
   return 0;
}

sub param_extract ( $$$ ) {
  my $file = shift;
  my $idx = shift;
  my $pos = shift;
  my $name = "";
  my $summary;
  my $skip = 0;
  my $prefix;
  my $cppflags = get_config_sh_var("FW_CPPFLAGS");
  my $preprocessed;
  my @rest;
  my $output = "";
  $preprocessed = `cpp -C -E -I$fw_topdir/doc/oem -I- $cpp_flags $file`;
  
 LOOP:
  foreach my $l (split(/\n/, $preprocessed)) {
    if ($l =~ /[\/ ](skip|desc|label|id|name|type|acl_object|flags|validate_regex|validate_min|validate_max|Action|Summary):\s*([a-zA-Z_0-9%\/\#\(\)\.\"\-\t :;]+),?$/)
    {
	if ($1 eq "Summary") {
	    $output .= sprintf "  Summary :\n    $2\n";
        }
        elsif ($1 eq "Action") {
	    $output .= sprintf "  Action :\n    $2\n";
        }
	
	elsif ($1 eq "id") {
	   last LOOP if $2 eq "-1";
	   $summary = "";
	   $name = "";
	   $skip = 0;
	   @rest = ();
        } 
        elsif ($skip == 1) {
	next LOOP;
      } elsif ($1 eq "skip") {
	$skip = 1;
      } elsif ($1 eq "desc") {
	$summary = $2;
      } elsif ($1 eq "name") {
	$name = substr $2, 1, length ($2) - 2;
      } elsif ($1 eq "type") {
	if ($2 eq "FV_TYPE_TARGET_USER") {
	  $prefix = "ECTU_"; 
	} elsif ($2 eq "FV_TYPE_GLOBAL") {
	  $prefix = "ECG_"; 
	} elsif ($2 eq "FV_TYPE_GLOBAL_TAGABLE") {
	  $prefix = "ECGT_";
	} elsif ($2 eq "FV_TYPE_NONE") {
	  $prefix = "";
	}
	if ($name ne "") {
	  #prints the information after collecting it (after getting name,summary and prefix)
	  $output .= sprintf "%s%d. %-16s \"%s\"\n",get_spaces($pos), $idx++, "Parameter:", $prefix . $name;
	  if ($summary ne "") { $output .= sprintf "%s%-16s %s\n", get_spaces($pos + 3), "Summary:", $summary; }
	  $summary = "";
	  $name = "";
	}
	else {
	  printf "       No label given.\n";
	}
      } elsif ($1 eq "label") {
	if ($summary eq "") {	#if summary is not yet defined, we save the current info
	  $summary = substr $2, 1, length ($2) - 2;
	}
      } elsif ($1 ne "flags" or ($2 ne "0" and $2 ne "FV_FLAG_DONT_SAVE" and $2 ne "FV_FLAG_WIZARD_VALUE" and $2 ne "")) {
	  $output .= sprintf "%s%-16s %s\n",get_spaces($pos + 3), $1 . ":", $2;
      } 
    }
  }
  if ($idx == 1) {
     return "";
  }   
  else {
  return $output;
  }
}

sub get_spaces( $ ) {
  return substr "                          ", 0, shift;
}

sub get_config_sh_var($) {
  my $key = shift;
  my $value = `source ../Config.sh; echo \$$key`;
  chop($value);
  return $value;
}
