#
# compiling the remote console applet
# 25.10.01 by Thomas Breitfeld, Peppercon AG
#

INREPO = $(shell if test -f $(TOP)/../Config.mk; then echo "yes"; else echo "no"; fi)

ifeq ($(INREPO),yes)
include $(TOP)/../Config.mk
else
include $(TOP)/Config.mk
endif


JAVAC     = $(PP_JAVA_HOME)/bin/javac
JAR       = $(PP_JAVA_HOME)/bin/jar
JAVA      = $(PP_JAVA_HOME)/bin/java
JARSIGNER = $(PP_JAVA_HOME)/bin/jarsigner
JFLAGS    = -target 1.1 -source 1.3 -encoding ISO-8859-1 -O

APPLET_NAME = rc

JAVA_SRCDIR          = $(TOP)/src
JAVA_CLASSDIR        = $(TOP)/classes

ifeq ($(INREPO),yes)
KEYSTORE_ALIAS = $(shell cat $(OEMDIR)/keystore_alias)
PP_JARSIGNER_KEY_PWD = cellcore
 ifeq ($(PP_FW_TYPE),ccf)
 INSTALLDIR = $(DESTDIR)/var/www/html
 else
 INSTALLDIR = $(DESTDIR)/lib/webpages
 endif
else
KEYSTORE_ALIAS = example
PP_JARSIGNER_KEY_PWD = example
INSTALLDIR = $(DESTDIR)
endif


ifeq ($OS, Windows_NT)
	CLASSPATH 	= "$(JAVA_CLASSDIR);$(TOP)/nsssl.jar;$(TOP)/plugin14.jar;$(TOP)/deploy15.jar"
else
	CLASSPATH 	= $(JAVA_CLASSDIR):$(TOP)/nsssl.jar:$(TOP)/plugin14.jar:$(TOP)/deploy15.jar
endif


# rule for creating destination directory
$(JAVA_CLASSDIR):
	mkdir $@


# pattern rule for compiling java Files
# Attention: JAVA_CLASSDIR and JAVA_SRCDIR must be properly defined
#            _before_ this rule is included in another Makefile
#
$(JAVA_CLASSDIR)/%.class : $(JAVA_SRCDIR)/%.java
	$(JAVAC) $(JFLAGS) -classpath $(CLASSPATH) -sourcepath $(JAVA_SRCDIR) -d $(JAVA_CLASSDIR) $<


# pattern rule for copying the image files over to classes
$(JAVA_CLASSDIR)/%.gif : $(JAVA_SRCDIR)/%.gif
	cp $< $@
$(JAVA_CLASSDIR)/%.txt : $(JAVA_SRCDIR)/%.txt
	cp $< $@

