import java.awt.*;
import java.applet.*;
import java.awt.event.*;
import nn.pp.rckbd.*;


public class nograph extends Applet implements ScanCodeListener, KeyListener, ActionListener
{
 	
    private TextField textfeld;
    private TextField eingabefeld;
    private Button getfocus;
    private KbdFactory kbdfac;
    private String layout = "102pc";
    private KeyEventHandler evth;
 
    public void init() {	
	setLayout(new FlowLayout());
	addKeyListener(this);
	requestFocus();
	getfocus=new Button("Request Focus");
	getfocus.addActionListener(this);
	add(getfocus);
	kbdfac = KbdFactory.getInstance();
	evth = new KeyEventHandler(kbdfac.getKbdLayout(layout));
	evth.addScanCodeListener(this);
  
	eingabefeld=new TextField(80);
	eingabefeld.setEditable(false);
	add(new Label("letzte Eingaben: "));
	eingabefeld.setText("");
	add(eingabefeld);
	textfeld=new TextField(80);
	textfeld.setEditable(false);
	add(new Label("letzte Scancodes: "));
	textfeld.setText(" ");
	add(textfeld);
 
    }
 	
    public void fired(ScanCodeEvent e)  {
	String s = textfeld.getText();
 	if(s.length() > 80) s="";
 	for(int i=0; i<e.scancode.length; i++) {
	    s = s + " " +Integer.toHexString(0xff & e.scancode[i]);
	}
 	textfeld.setText(s);
 	requestFocus();
    }

    public void keyPressed(KeyEvent e) 
    {
	// little test, what happens if we change kbd dynamically
	Short keynr=kbdfac.getKeyTranslator(evth.getActualLayout().getName(),
					    getLocale()).translateKeyEvent(e);
	if(keynr==null) {
	    System.out.println("ERROR: no key number found for " + e);
	    return;
	}
	evth.pressed(keynr, KeyEventHandler.KEYBOARD);
    }
  
    public void keyReleased(KeyEvent e) 
    {
	Short keynr=kbdfac.getKeyTranslator(evth.getActualLayout().getName(),
					    getLocale()).translateKeyEvent(e);
	if(keynr==null) {
	    System.out.println("ERROR: no key number found for " + e);
	    return;
	}
	evth.released(keynr, KeyEventHandler.KEYBOARD);
    }

    public void keyTyped(KeyEvent keyevt) {
    	String s = eingabefeld.getText();
	if(s.length() > 80) s="";
	s = s + keyevt.getKeyChar();
	eingabefeld.setText(s);
	requestFocus();
    }
  
    public void actionPerformed(ActionEvent actevt)
    {
	requestFocus();
    } 
}
