package nn.pp.drvredir;

import java.io.*;
import java.awt.*;
import java.awt.event.*;

import nn.pp.rc.*;

abstract class ConnectionHandler extends Thread implements ActionListener {
    RFBProfile prof;
    DrvRedirSettingsPanel panel;
    DriveAccess drvAccess;
    MSPProto proto;
    PrintStream logger;
    boolean writeSupport = false;
    boolean running;
    boolean killThread = false;
    GenericTimer timer;
    
    ConnectionHandler(RFBProfile prof, DrvRedirSettingsPanel panel, DriveAccess drvAccess, PrintStream logger,
                      int msIndex) {
    	this.prof = prof;
    	this.panel = panel;
    	this.drvAccess = drvAccess;
    	this.logger = logger;
    	this.writeSupport = writeSupport;
    	proto = new MSPProto(prof, logger, drvAccess, msIndex);
        timer = new GenericTimer(500, this);
    }
    
    static void debug(String s) {
    	if (false) System.out.println(s);
    }
    
    abstract void connect() throws Exception;
    abstract void disconnect();
    
    protected void doConnect() throws Exception {
    	proto.initializeMSPConnection(writeSupport);
    	startProcessingThread();
    	timer.start();
    }
    
    protected void doDisconnect() {
        timer.stop();
    	stopProcessingThread();
    	try {
    	    proto.closeConnection(false);
    	} catch (Exception ignore) { }
    }
    
    void startProcessingThread() {
    	debug("Starting message processing thread.");
    	
    	killThread = false;
    	start();
    }
    
    void stopProcessingThread() {
    	debug("Stopping message processing thread.");
    	
    	killThread = true;
    	proto.closeConnection(true);
	
	if (running) {
	    try {
	    	join(1000);
	    	// netscape 4.7 seems to have a bug with respect to
	    	// sockets. they don't throw an execption if another
	    	// thread is closing them. So in case our thread is still
	    	// alive after we return from the join, we bruttally
	    	// destroy it. Not nice but OK
	    	if(isAlive()) {
		    System.out.println("Frame: cleanup: thread " + this +
				       "still alive, killing forcefully!");
		    stop();
	    	}
	    } catch(Exception e) {
	    	e.printStackTrace();
	    }
	    
	    debug("message processing thread finished.");
	}
	
	running = false;
    }
    
    public void run() {
    	running = true;
    	
    	debug("message processing thread started.");
    	
    	try {
    	    proto.processProtocol();
    	} catch (Exception e) {
    	    logger.println(e.getMessage());
    	    running = false;
    	    panel.disconnected(!killThread);
    	}
    	
    	debug("message processing thread finishing.");
    }

    abstract void mediumRemovedForChange() throws Exception;
    abstract void mediumInsertedAfterChange() throws Exception;

    private void checkMediumChange() {
        try {
            switch (drvAccess.getMediumChangeState()) {
                case DriveAccess.CD_EXT_MEDIUM_NO_CHANGE:
                    //debug("Medium not changed.");
                    break;
                case DriveAccess.CD_EXT_MEDIUM_REMOVED:
                    debug("Medium has been removed.");
                    mediumRemovedForChange();
                    break;
                case DriveAccess.CD_EXT_MEDIUM_CHANGED:
                    debug("Medium has been changed.");
                    mediumInsertedAfterChange();
                    break;
            }
        } catch (Exception e) {
            disconnect();
        }
    }

    public void actionPerformed(ActionEvent e) {
    	Object src = e.getSource();
    	
    	if (src == timer) {
    	    checkMediumChange();
    	}
    }
}
