package nn.pp.drvredir;

import java.io.*;
import java.awt.*;

import nn.pp.rc.*;

class ConnectionHandlerDriveLinux extends ConnectionHandler {
    DrvRedirDriveLinux drv;
    String drive;
    String directory, filename;
    boolean forceReadOnly;
    
    ConnectionHandlerDriveLinux(RFBProfile prof, DrvRedirSettingsPanel panel, PrintStream logger, int msIndex, boolean forceReadOnly) {
        super(prof, panel, new DrvRedirDriveLinux(), logger, msIndex);
        // must be done this way since iso cannot be referenced until super constructor has been called
        drv = (DrvRedirDriveLinux)drvAccess;
        this.forceReadOnly = forceReadOnly;
    }
    
    void chooseDrive(Frame frame) throws IOException {
        DriveSelectionDialog dlg = new DriveSelectionDialog(frame, drv, logger, forceReadOnly);
        dlg.show();
        
        if (dlg.ok) {
            drive = dlg.drive;
            writeSupport = dlg.writeSupport;
        } else {
            throw new IOException(T._("Cancelled Drive redirection"));
        }
    }
    
    void connect() throws Exception {
        directory = drive.substring(0, drive.lastIndexOf("/"));
        filename = drive.substring(drive.lastIndexOf("/") + 1);

        drv.openFile(directory, filename, !writeSupport);
        doConnect();
    }
    
    void disconnect() {
        doDisconnect();
        drv.closeFile();
    }

    void mediumRemovedForChange() throws Exception {
        drv.mediumRemovedForChange();
        proto.sendMediumRemoval();
    }
    
    void mediumInsertedAfterChange() throws Exception {
        // close the drive
        drv.closeFile();
        
        // open the drive again
        drv.openFile(directory, filename, !writeSupport);
        
        // medium change done
        drv.mediumInsertedAfterChange();

        proto.sendMediumChange();
    }
}
