package nn.pp.drvredir;

import java.io.*;
import java.awt.*;

import nn.pp.rc.*;

class ConnectionHandlerIso extends ConnectionHandler {
    DrvRedirIso iso;
    String directory, filename;
    
    ConnectionHandlerIso(RFBProfile prof, DrvRedirSettingsPanel panel, PrintStream logger, int msIndex) {
        super(prof, panel, new DrvRedirIso(), logger, msIndex);
        // must be done this way since iso cannot be referenced until super constructor has been called
        iso = (DrvRedirIso)drvAccess;
    }
    
    void chooseIsoFile(Frame frame) throws IOException {
        FileDialog chooser = new FileDialog(frame, T._("Choose ISO image to redirect"), FileDialog.LOAD);
        chooser.setDirectory(System.getProperty("user.home"));
        chooser.show();
        
        filename = chooser.getFile();
        directory = chooser.getDirectory();
        if (filename == null || directory == null) {
            throw new IOException(T._("No ISO file chosen"));
        }
        
        RandomAccessFile file = new RandomAccessFile(new File(directory, filename), "r");
        boolean isValid = iso.isFloppy(file) || iso.isIso(file) || iso.isRemovable(file) || iso.isFixed(file);
        try { file.close(); } catch (IOException ignore) { }
        if (!isValid) {
            ConfirmDialog dlg = new ConfirmDialog(
		        T._("The file you selected is not a valid image file."),
		        T._("Warning"), ConfirmDialog.OK, true);
            dlg.show();
            throw new IOException(T._("Invalid file selected"));
        }

        
        debug("Redirecting file " + filename);
    }
    
    void connect() throws Exception {
        iso.openFile(directory, filename, true);
        doConnect();
    }
    
    void disconnect() {
        doDisconnect();
        iso.closeFile();
    }

    // medium change not supported for file based redirection
    void mediumRemovedForChange() throws Exception {
    }
    
    void mediumInsertedAfterChange() throws Exception {
    }
}
