package nn.pp.drvredir;

class Drive implements Comparable {
    private String driveName;
    private String description;
    
    public Drive(String driveName, String description) {
        this.driveName = driveName;
        this.description = description;
    }
    
    public String getName() {
        return driveName;
    }
    
    public String getDescription() {
        return description;
    }
    
    public String getNameAndDescription() {
        return description == null ? driveName : driveName + " (" + description + ")";
    }
    
    public int compareTo(Object o) {
        Drive d = (Drive)o;
        return driveName.compareTo(d.getName());
    }
}
