package nn.pp.drvredir;

import java.io.IOException;

interface DriveAccess {
    public boolean mediumChangeSupported();
    public Drive[] getAvailableDrives();
    public int getMSPDriveType() throws IOException;
    public int getSectorSize() throws IOException;
    public int getSectorNo() throws IOException;
    public void readCDSectors(long startSector, long noSectors, byte dataBuf[]) throws IOException;
    public void writeCDSectors(long startSector, long noSectors, byte dataBuf[]) throws IOException;
    public int getMediumChangeState();

    // return codes for cdExtGetMediumChangeState();
    final static int CD_EXT_MEDIUM_NO_CHANGE = 0;
    final static int CD_EXT_MEDIUM_REMOVED = 1;
    final static int CD_EXT_MEDIUM_CHANGED = 2;
    
}
