package nn.pp.drvredir;

import java.io.*;
import java.util.*;
import java.net.*;

import nn.pp.rc.*;

class LibraryDownloader {
    private static void debug(String s) {
    	if (true) System.out.println(s);
    }
    
    /* find the name of the native implementation on the webserver */
    private String getFileSuffix() throws Exception {
    	if (System.getProperty("os.name").startsWith("Windows")) {
    	    return ".dll";
    	}
    	
    	throw new IOException(T._("Not supported by Operating System"));
    }    
    
    private String buildSourceFileName() throws Exception {
    	return "DrvRedirNative" + getFileSuffix();
    }
    
    private String getTimeString() {
    	Calendar cal = Calendar.getInstance();
    	int y = cal.get(Calendar.YEAR);
    	int m = cal.get(Calendar.MONTH);
    	int d = cal.get(Calendar.DAY_OF_MONTH);
    	int h = cal.get(Calendar.HOUR_OF_DAY);
    	int min = cal.get(Calendar.MINUTE);
    	int s = cal.get(Calendar.SECOND);
    	
    	String ret = new String("");
    	
    	ret += y;
    	if (m < 10) ret += "0";
    	ret += m;
    	if (d < 10) ret += "0";
    	ret += d;
    	ret += "-";
    	if (h < 10) ret += "0";
    	ret += h;
    	if (min < 10) ret += "0";
    	ret += min;
    	if (s < 10) ret += "0";
    	ret += s;
    	
    	return ret;
    }
    
    /* write the library to a local temp file */
    private File downloadToLocal(InputStream is) throws Exception {
    	File localFile = null;
    	
    	localFile = File.createTempFile("DrvRedir-" + getTimeString() + "-", getFileSuffix());
    	
    	FileOutputStream os = new FileOutputStream(localFile);
    	byte temp[] = new byte[4096];
    	int read;
    	int totally_read = 0;
    	
    	while ((read = is.read(temp)) != -1) {
    	    os.write(temp, 0, read);
    	    totally_read += read;
    	}
    	
    	os.close();
    	is.close();
    	
    	debug("Downloaded " + totally_read + " bytes of native code to " + localFile.getCanonicalPath() + ".");
    	
    	return localFile;
    }
    
    public File downloadFromWeb(String appletUrl) throws Exception {
    	String urlString = new String(appletUrl);
    	
    	if (!appletUrl.endsWith("/")) {
    	    urlString += "/";
    	}
    	urlString += buildSourceFileName();
    	
	debug("Loading DriveRedirection from " + urlString);
	
	URL url = new URL(urlString);
	URLConnection urlConnection = url.openConnection();
	urlConnection.connect();
	InputStream is = urlConnection.getInputStream();
    	
    	return downloadToLocal(is);
    }
    
    public File downloadFromLocalFile() throws Exception {
    	File sourceFile = new File(buildSourceFileName());
    	FileInputStream is = new FileInputStream(sourceFile);
    	
    	debug("Loading DriveRedirection from file " + sourceFile.getCanonicalPath());
    	
    	return downloadToLocal(is);
    }
}
