package nn.pp.rc;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.text.*;
import java.util.*;
import nn.pp.rckbd.*;

public class ButtonPanel extends Panel
{
    public static final boolean debug = false;
    ServerConsolePanelBase frame;
    KeyEventHandler keh;
    PrintStream logger;
    boolean monimode;
    int keypause;
    Vector buttons = new Vector();
    private int preferred_width = 500;
    private boolean use_preferred_width = false;
    static final int KEYDELI_ADD      = 0xf0;
    static final int KEYDELI_SEPERATE = 0xf1;
    static final int KEYDELI_PAUSE    = 0xf2;
	
    public ButtonPanel(ServerConsolePanelBase frame, KeyEventHandler keh,
		       String[] hotkeys, String[] hotkeycodes,
		       String[] hotkeynames,
		       PrintStream logger, boolean monimode, int keypause) {
	this.frame = frame;
	this.logger = logger;
	this.monimode = monimode;
	this.keh = keh;
	this.keypause = keypause;
	setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
	
	// check wether our two arrays have the same length
	int l = hotkeys.length;
	if(l != hotkeycodes.length) {
	    logger.println(T._("Console: WARNING: hotkey definition mismatch, some buttons will be ignored"));
	    l = Math.min(hotkeys.length, hotkeycodes.length);
	}
	
	for(int i = 0; i < l; ++i) {
	    try {
		Button b;
		if (hotkeycodes[i] != null && hotkeycodes[i].length() != 0) {
		    if(hotkeycodes[i].startsWith("kvm")) {
			b = new KvmPortButton(hotkeys[i], hotkeycodes[i]);
		    } else {
			b = new HotKeyButton(hotkeys[i], hotkeycodes[i],
					     hotkeynames[i]);
		    }
		    add(b);
		    buttons.addElement(b);
		}
	    } catch(ParseException e) {
		logger.println(T._("Console: hotkey error:") + " " + e);
	    }
	}
    }

    public Dimension getPreferredSize() {
	Component[] comp = getComponents();
	if (comp.length == 0) return new Dimension(0, 0);
	int bh = comp[0].getPreferredSize().height;
	int h = 1, w = 0;
	for (int i = 0; i < comp.length; ++i) {
	    int bw = comp[i].getPreferredSize().width;
	    if ((w += bw) > preferred_width) {
		use_preferred_width = true;
		w = bw;
		++h;
	    }
	}
	int cw = use_preferred_width ? preferred_width : w;
	//System.out.println("ButtonPanel: w=" + cw + " h=" + h * (bh + 1));
	return new Dimension(cw, h * (bh + 1));
    }

    /* this fkt does not call validate itself                  *
     * it rather expects the one calling this fkt to validate  *
     * the component (usally frame) this panel is part of      */
    public void setPreferredWidth(int w) {
	preferred_width = w;
	/* without this layouting fails, sometimes, not sure why */
	if (use_preferred_width == true) {
	    setSize(w, getSize().height);
	}
    }
    
    public void setEnabled(boolean switchOn) {
    	Enumeration e;
    	for (e = buttons.elements(); e.hasMoreElements(); ) {
    	    Button b = (Button)e.nextElement();
    	    b.setEnabled(switchOn);
    	}
    }

    public void setMonitorMode(boolean moni) {
	monimode = moni;
    }

    class HotKeyButton extends Button implements ActionListener {
	private static final String CONFIRM = "confirm";
	private boolean confirm;
	private Vector codes;

	public HotKeyButton(String hotkey, String codes, String name)
	    throws ParseException {
	    setButtonKey(hotkey, codes, name);
	    addActionListener(this);
	}
	
	public void actionPerformed(ActionEvent ev) {
	    frame.handleFocus((Component)ev.getSource());
	    if(monimode) return;
	    if(confirm) {
		ConfirmDialog d = new ConfirmDialog(
		    MessageFormat.format(T._("Do you really want to send \"{0}\"?"),
		                        new Object[] { getLabel() }),
		    T._("Confirmation"), ConfirmDialog.OK_CANCEL, true);
		d.show();
		boolean ok = d.ok;
		d.dispose();
		d = null;
		if(ok == false) return;
	    }
	    /*
	     * go through the keys and generate all pressed/released
	     * events according to the delemitters given in the same
	     * keycode vector
	     */
	    Stack relkeys = new Stack();
	    for(int i=0; i<codes.size(); ++i) {
		Short keynr = (Short)codes.elementAt(i);
		short k = keynr.shortValue();
		if(debug) System.out.println("ButtonKey: keyNo: " + keynr);
		switch(k) {
		  case KEYDELI_PAUSE:
		      try{Thread.sleep(keypause);}catch(Exception e){}
		      break;
		  case KEYDELI_SEPERATE:
		      releaseStackKeys(relkeys);
		  case KEYDELI_ADD:
		      break;
		  default:
		      relkeys.push(keynr);
		      keh.internalPressed(keynr, KeyEventHandler.KEYBOARD);
		}
	    }
	    releaseStackKeys(relkeys);
	}

	private void releaseStackKeys(Stack keys) {
	    try {
		while(true) {
		    Short keynr = (Short)keys.pop();
		    keh.released(keynr, KeyEventHandler.KEYBOARD);
		}
	    } catch (EmptyStackException finish) {}
	}
	    
	private void setButtonKey(String text, String kcodes, String name)
	    throws ParseException {

	    // confirm or not confirm
	    if (text==null || text.length()==0)
		throw new ParseException(text, 0);
	    String keyText = text.trim();
	    confirm = false;
	    if(keyText.startsWith(CONFIRM)) {
		confirm = true;
		keyText = keyText.substring(CONFIRM.length());
		keyText = keyText.trim();
	    }
	    if (name != null && name.length() > 0) {
		setLabel(name);
	    } else {
		setLabel(keyText);
	    }
	    
	    // parse the associated codes
	    codes = new Vector();
	    StringTokenizer st = new StringTokenizer(kcodes);
	    while(st.hasMoreTokens()) {
		try {
		    int c = Integer.parseInt(st.nextToken(), 16);
		    codes.addElement(new Short((short)c));
		} catch(NumberFormatException e) {
		    throw new ParseException(kcodes, 0);
		}
	    }
	}
    }

    class KvmPortButton extends Button implements ActionListener {
	short portno;
	
	public KvmPortButton(String hotkey, String code)
	    throws ParseException {
	    super(hotkey);
	    StringTokenizer st = new StringTokenizer(code);
	    // second token is expected to be our port number
	    try {
		st.nextToken();
		portno = Short.parseShort(st.nextToken(), 10);
	    } catch(Exception e) {
		throw new ParseException(code, 0);
	    }
	    addActionListener(this);
	}
	
	public void actionPerformed(ActionEvent ev) {
	    frame.handleFocus((Component)ev.getSource());
	    frame.console.switchKvmPort(portno);
	}
    }
}
