package nn.pp.rc;

import java.util.*;
import java.text.*;
import java.awt.Color;

class ConnectionParameter {
    String name;
    String value;
    
    ConnectionParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }
}

class ConnectionParameters implements ParameterReader {
    
    /*-------------------- constants ----------------------------------*/
    
    public final static int OSD_TOP = 0;
    public final static int OSD_CENTER = 1;
    public final static int OSD_BOTTOM = 2;

    /*-------------------- public variables ---------------------------*/
    
    /**
     * class with all encoding parameters
     */
    public RFBEncoding encoding = new RFBEncoding();
    
    /**
     * enable drive redirection?
     * number of drives for drive redirection
     */
    public int driveRedirectionNoDrives = 0;
    public boolean driveRedirectionForceReadOnly = false;
    
    /**
     * OSD properties
     */
    public Color osdBgColor = new Color(0x20, 0x20, 0x80);
    public Color osdFgColor = new Color(0x60, 0x60, 0xF0);
    public int osdAlpha = 100;
    public int osdPosition = OSD_TOP;


    /**
     * Misc things
     */
    String boardname;

    boolean use_iip = false;
    boolean exclusiveMouse = false;
    String kbdLayout;
    String localcursor;

    boolean monitorOn = false;
    boolean monitorPerm = true;

    boolean exclusiveOn   = false;
    boolean exclusivePerm = false;
    
    String[] hotkeys;
    String[] hotkeycodes;
    String[] hotkeynames;
    
    String softKbdMapping;
    String localKbdMapping;

    String synckey;
    String synckeycodes;
    String fskeycodes;
    int keypause;

    boolean vs_type_full = true;
    int vs_perms = 0;
    boolean encodingPerm = false;
    
    boolean isWlanEnabled = false;

    /*-------------------- private variables and constructor ----------*/
    private Vector params;
    
    ConnectionParameters() {
        params = new Vector();
    }
    
    /*-------------------- overridden methods --------------------------*/
    public void parameterError(String s) throws Exception {
    	throw new Exception(s);
    }
    
    public String readParameter(String reqName, boolean required) throws Exception {
    	reqName = reqName.toUpperCase();
    	String ret = null;
    	
    	for (int i = 0; i < params.size(); i++) {
    	    ConnectionParameter cp = (ConnectionParameter)params.elementAt(i);
    	    String name = cp.name.toUpperCase();
    	    if (name.equalsIgnoreCase(reqName)) {
    	        ret = cp.value;
    	        break;
    	    }
    	}

	if (ret == null && required) {
	    parameterError(MessageFormat.format(T._("Required parameter \"{0}\" not found"),
	               new Object[] { reqName }));
	}
	
	return ret;
    }
    
    public String[] readArrayParameter(String basename) throws Exception {
	int index = 0;
	String s;

	while (null != (s = readParameter(basename + index, false))) ++index;
	String[] params = new String[index];
	for(int i = 0; i < index; ++i) {
	    s = readParameter(basename + i, false);
	    params[i] = s;
	}
	return params;
    }

    public String getRemoteHost() throws Exception {
    	throw new Exception("Remote host not supported");
    }
    
    /*-------------------------- local methods --------------------------------*/
    
    public void add(String name, String value) {
        params.add(new ConnectionParameter(name, value));
    }

    public void setParameters() throws Exception {
	String s;
	
	readEncodingParameters2Profile();
	
	try {
	    driveRedirectionNoDrives = Integer.parseInt(readParameter("DRIVE_REDIRECTION_NO_DRIVES", false));
	} catch(Exception ignore) {}
	s = readParameter("drive_redirection_read_only", false);
	if (s != null && s.equalsIgnoreCase("yes")) {
	    driveRedirectionForceReadOnly = true;
	}

	s = readParameter("osd_bgcolor", false);
	if (s != null) {
	    osdBgColor = new Color(Integer.valueOf(s.substring(1), 16).intValue());
	}
	s = readParameter("osd_fgcolor", false);
	if (s != null) {
	    osdFgColor = new Color(Integer.valueOf(s.substring(1), 16).intValue());
	}
	s = readParameter("osd_position", false);
	if (s != null) {
	    if (s.equalsIgnoreCase("top")) {
	        osdPosition = OSD_TOP;
	    } else if (s.equalsIgnoreCase("center")) {
	        osdPosition = OSD_CENTER;
	    } else if (s.equalsIgnoreCase("bottom")) {
	        osdPosition = OSD_BOTTOM;
	    }
	}
	s = readParameter("osd_alpha", false);
	if (s != null) {
            osdAlpha = Integer.valueOf(s, 10).intValue();
	}

	s = readParameter("USE_IIP", false);
	if (s != null && s.equalsIgnoreCase("yes")) use_iip = true;
	s = readParameter("EXCLUSIVE_MOUSE", false);
	if(s != null && s.equalsIgnoreCase("yes")) exclusiveMouse = true;
	kbdLayout = readParameter("kbd_layout", false);
	localcursor = readParameter("LOCAL_CURSOR", false);

	boardname = readParameter("BOARD_NAME", false);
	if (boardname == null) boardname = new String("");
	
	s = readParameter("MONITOR_MODE", false);
	if(s != null) {
	    if(s.equalsIgnoreCase("yes")) monitorOn = true;
	    else if(s.equalsIgnoreCase("sticky")) {
		monitorOn = true;
		monitorPerm = false;
	    }
	}

	s = readParameter("EXCLUSIVE_PERM", false);
	if(s != null) {
	    if (s.equalsIgnoreCase("on"))	{
		exclusivePerm = true;
		exclusiveOn = true;
	    } else if (s.equalsIgnoreCase("off")) {
		exclusivePerm = true;
		exclusiveOn = false;
	    } else if (s.equalsIgnoreCase("sticky")) {
		exclusivePerm = false;
		exclusiveOn = true;
	    } else if (s.equalsIgnoreCase("no")) {
		exclusivePerm = false;
		exclusiveOn = false;
	    }
	}

	hotkeys = readArrayParameter("hotkey_");
	hotkeycodes = readArrayParameter("hotkeycode_");
	hotkeynames = readArrayParameter("hotkeyname_");

	System.out.println("k=" + hotkeys.length +
			   " c=" + hotkeycodes.length +
			   " n=" + hotkeynames.length +
			   " " + readParameter("hotkeyname_0", false));
	
	synckey = readParameter("MOUSESYNC_KEY", false);
	synckeycodes = readParameter("MOUSESYNC_KEYCODE", false);
	fskeycodes = readParameter("FULLSCREEN_KEYCODE", false);

        softKbdMapping = readParameter("softkbd_mapping", false);
        localKbdMapping = readParameter("localkbd_mapping", false);

	try { keypause = Integer.parseInt(readParameter("hotkeypause", false));
	} catch(Exception e) { keypause = 100; }

	/* video settings type and permissions (standard, advanced) */
	String vs_type_s = readParameter("VS_TYPE", false);
	if (vs_type_s != null && vs_type_s.equalsIgnoreCase("offset")) vs_type_full = false;
	String vs_std = readParameter("VS_PERM_STD", false);
	String vs_adv = readParameter("VS_PERM_ADV", false);
	if (vs_adv != null && vs_adv.equalsIgnoreCase("yes")) {
	    vs_perms = 2;
	} else if (vs_std != null && vs_std.equalsIgnoreCase("yes")) {
	    vs_perms = 1;
	}

	s = readParameter("VS_ENC", false);
	encodingPerm = ((s != null) && (s.equalsIgnoreCase("yes")));
	
	s = readParameter("WLAN_ENABLED", false);
	isWlanEnabled = ((s != null) && (s.equalsIgnoreCase("yes")));
	
	s = readParameter("charset", false);
	if (s != null) {
	    T.setCharset(s);
	}
    }

    private void readEncodingParameters2Profile() {
	String selEnc = null, fixEnc = null, encAdvCR = null, encAdvCD = null, supportHwS = null;
	boolean supportHw = false;

	try {
	    selEnc = readParameter("SelEnc", false);
	    fixEnc = readParameter("FixEnc", false);
	    encAdvCD = readParameter("AdvEncCD", false);
	    encAdvCR = readParameter("AdvEncCR", false);
	    supportHwS = readParameter("HWENC", false);
	    supportHw = ((supportHwS != null) && supportHwS.equalsIgnoreCase("yes")) ? true : false;
	} catch(Exception ignore) { }

	if (selEnc == null)	selEnc = RFBproto.DefaultSelectedEncoding;
	if (fixEnc == null)	fixEnc = RFBproto.DefaultFixEncoding;
	if (encAdvCR == null)	encAdvCR = RFBproto.DefaultEncodingAdvCR;
	if (encAdvCD == null)	encAdvCD = RFBproto.DefaultEncodingAdvCD;
	if (supportHwS == null)	supportHw = false;

	encoding = new RFBEncoding(supportHw, selEnc, fixEnc, encAdvCR, encAdvCD);
    }
}
