package nn.pp.rc;

import java.io.*;
import java.net.*;
import java.text.*;
import java.awt.*;
import java.awt.event.*;
import java.util.zip.*;
import java.lang.reflect.*;
import java.security.*;
import javax.net.ssl.*;

public class ErlaConnector {
    public  RFBProfile profile;	
    boolean isSecure = false;
    String secDesc = "";
    protected String sockerr = "";
    PrintStream logger;
    private String protocol;
    
    public ErlaConnector(RFBProfile profile, PrintStream logger, String protocol) {
    	this.profile = profile;
    	this.logger = logger;
    	this.protocol = protocol;
    }

    /**
     * tries to make a normal Socket connection
     */
    public Socket connect(String host, int port) {
	String hp = "" + host + ':' + port;
	logger.println(protocol + ": " + MessageFormat.format(T._("trying connection to {0}"),
	               new Object[] { hp }));
	Socket s = null;
	try {
	    s = new Socket(host, port);
	    logger.println(protocol + ": " + MessageFormat.format(T._("connected successfully to {0}"),
	                   new Object[] { hp }));
	    isSecure = false;
	    secDesc = T._("Norm");
	} catch (Exception e) {
	    logger.println(protocol + ": " + T._("connect:") + " " + e);
	    logger.println(protocol + ": " + MessageFormat.format(T._("connection FAILED to {0}"),
	                   new Object[] { hp }));
	    sockerr = e.getMessage();
	}
	return s;
    }

    /**
     * tries to make a Socket connection over
     * a http proxy tunnel
     */
    public Socket connectProxy(String proxyHost, int proxyPort, 
				String host, int port) {
	String hp = "" + host + ':' + port;
	String php = "" + proxyHost + ':' + proxyPort;
	logger.println(protocol + ": " + MessageFormat.format(T._("trying to TUNNEL over proxy {0} to {1}"),
	               new Object[] { php, hp }));
	Socket s = null;
	try {
	    s = new TunnelSocket(proxyHost, proxyPort, host, port);
	    logger.println(protocol + ": " + MessageFormat.format(T._("tunneled successfully to {0}"),
	                   new Object[] { hp }));
	    isSecure = true;
	    secDesc = T._("tunneld SSL");
	} catch (Exception e) {
	    logger.println(protocol + ": " + T._("TUNNEL connect:") + " " + e);
	    logger.println(protocol + ": " + MessageFormat.format(T._("TUNNEL connection FAILED to {0}"),
	                   new Object[] { hp }));
	}
	return s;
    }

    /**
     * tries to determine the right method for the SSL connection
     * and calls it.
     * Currently we distinguish between Java 1.5, 1.4 and the rest
     * if java 1.4/1.5 is there we should have automatically installed
     * the JSSE, so we try to use that
     * otherwise we simply try the netscape method what of course
     * might fail
     */
    public Socket connectSSL(String host, int port) {
	SSLConnector con = null;
	String sslimplid = null;
	JVMVersionInfo verInfo = JVMVersionInfo.getJVMVersionInfo();

	if(verInfo.isJava15()) sslimplid = "JSSE15";
	else if(verInfo.isJava14()) sslimplid = "JSSE14";
	else if(verInfo.isJava13()) sslimplid = "JSSE10";
	else if(verInfo.isNSJava()) sslimplid = "NS";
	if(sslimplid != null)
	    con = SSLConnector.getConnector(sslimplid, logger, protocol);
	if(null == con) {
	    sockerr = T._("no SSL implementation available");
	    logger.println(protocol + ": " + T._("SSL: WARNING:") + " " + sockerr);
	    return null;
	}
	isSecure = true;
	secDesc = T._("SSL");
	Socket s = con.connect(host, port);
	sockerr = con.error;
	return s;
    }
    
    protected String binToHex(byte[] bin) {
    	String hex = "";
    	for (int i = 0; i < bin.length; i++) {
    	    int b = bin[i] & 0xff;
    	    if (b <= 0x0f) {
    	    	hex += "0";
    	    }
    	    hex += Integer.toHexString(b).toUpperCase();
    	}
    	return hex;
    }
    
    protected void getChallengeResponse(byte[] challenge, byte[] response, int pos) throws IOException {
    	MessageDigest digest;
    	
    	try {
    	    digest = MessageDigest.getInstance("MD5");
    	} catch (NoSuchAlgorithmException e) {
    	    throw new IOException("Could not find MD5 algorithm.");
    	}
    	
    	digest.update(challenge);
    	digest.update(profile.connectId.getBytes("ISO-8859-1"), 0, profile.connectId.length());
    	
    	byte[] hash = digest.digest();
    	String hashString = binToHex(hash);
    	System.arraycopy(hashString.getBytes("ISO-8859-1"), 0, response, pos, hashString.length());
    }
}

/**
 * that's a little abstraction used for connecting SSL using
 * differnt SSL packs. We need to do that in polymorphic classes
 * in order to be able to load the classes dynamically by its names
 */
abstract class SSLConnector {
    protected PrintStream logger;
    public String error;
    public String protocol;
    /**
     * tries to instantiate the right connector
     */
    public static SSLConnector getConnector(String implid, PrintStream logger, String protocol) {
	SSLConnector con = null;
	try {
	    String c = "nn.pp.rc." + implid + "_SSLConnector";
	    con = (SSLConnector)Class.forName(c).newInstance();
	    con.logger = logger;
	    con.protocol = protocol;
	} catch(Throwable e) {
	    logger.println(protocol + ": " + "getSSLConnector: " + e);
	}
	return con;
    }
    public abstract Socket connect(String host, int port);
}

/**
 * tries to make an SSL connection using the Netscape SSL class
 */
class NS_SSLConnector extends SSLConnector {
    public Socket connect(String host, int port) {
	String hp = "" + host + ':' + port;
	logger.println(protocol + ": " + MessageFormat.format(T._("trying NS-SSL connection to {0}"),
	               new Object[] { hp }));
	Socket s = null;
	try {
	    s = new netscape.net.SSLSocket(host, port);
	    logger.println(protocol + ": " + MessageFormat.format(T._("NS-SSL connected successfully to {0}"),
	                   new Object[] { hp }));
	} catch (Exception e) {
	    logger.println(protocol + ": " + T._("NS-SSL connect:") + " " + e);
	    logger.println(protocol + ": " + MessageFormat.format(T._("NS-SSL connection FAILED to {0}"),
	                   new Object[] { hp }));
	    error = e.getMessage();
	}
	return s;
    }
}

/**
 * abstract base class for JSSE SSL connectors
 */
abstract class JSSE_SSLConnector extends SSLConnector {
    protected String id;
    abstract public SSLSocketFactory getSocketFactory()
	throws GeneralSecurityException;
    public Socket connect(String host, int port) {
	String hp = "" + host + ':' + port;
	logger.println(protocol + ": " + MessageFormat.format(T._("trying {0}-SSL connection to {1}"),
	               new Object[] { id, hp }));
	SSLSocket s = null;
	try {
	    s = (SSLSocket)getSocketFactory().createSocket(host, port);
	    logger.println(protocol + ": " + MessageFormat.format(T._("{0}-SSL connected successfully to {1}"),
	                   new Object[] { id, hp }));
	    logger.println(protocol + ": " + MessageFormat.format(T._("{0}-SSL running handshake..."),
	                   new Object[] { id }));
	    s.startHandshake();
	    logger.println(protocol + ": " + MessageFormat.format(T._("{0}-SSL handshake successful :-)"),
	                   new Object[] { id }));
	    logger.println(protocol + ": " + MessageFormat.format(T._("{0}-SSL {1}"),
	                   new Object[] { id, s.getSession() }));
	} catch (Exception e) {
	    logger.println(protocol + ": " + MessageFormat.format(T._("{0}-SSL connect:"),
	                   new Object[] { id }) + e);
	    logger.println(protocol + ": " + MessageFormat.format(T._("{0}-SSL connection FAILED to {1}"),
	                   new Object[] { id, hp }));
	    error = e.getMessage();
	    s = null;
	}
	return s;
    }
}

/**
 * tries to connect an SSL connection using the
 * Java Secure Socket Extensions included in j2se 1.5
 * (TrustManager dialog located in deploy.jar)
 */
class JSSE15_SSLConnector extends JSSE_SSLConnector {
    public JSSE15_SSLConnector() {
	id = "JSSE15";
    }
    public SSLSocketFactory getSocketFactory()
	throws GeneralSecurityException {
	TrustManager[] tms = new TrustManager [] {
	    new  com.sun.deploy.security.X509DeployTrustManager()
	};
	SSLContext ctx = SSLContext.getInstance("TLSv1");
	ctx.init(null, tms, null);
	return ctx.getSocketFactory();
    }
}

/**
 * tries to connect an SSL connection using the
 * Java Secure Socket Extensions included in j2se 1.4
 * (TrustManager dialog located in plugin.jar)
 */
class JSSE14_SSLConnector extends JSSE_SSLConnector {
    public JSSE14_SSLConnector() {
	id = "JSSE14";
    }
    public SSLSocketFactory getSocketFactory()
	throws GeneralSecurityException {
	TrustManager[] tms = new TrustManager [] {
	    new  sun.plugin.security.X509PluginTrustManager()
	};
	SSLContext ctx = SSLContext.getInstance("TLSv1");
	ctx.init(null, tms, null);
	return ctx.getSocketFactory();
    }
}


/**
 * tries to connect an SSL connection using the
 * Java Secure Socket Extensions 1.0.x. This is
 * almost identical to the 1.4 version, however the user
 * must have managed to install an JSSE into its java
 * runtime, what is not trivial, but not impossible.
 * Moreover the Peppercon CA certificate must be manually
 * trusted, otherwise the connection won't be established
 */
class JSSE10_SSLConnector extends JSSE_SSLConnector {
    public JSSE10_SSLConnector() {
	id = "JSSE10";
    }
    public SSLSocketFactory getSocketFactory()
	throws GeneralSecurityException {
	Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());
	return (SSLSocketFactory)SSLSocketFactory.getDefault();
    }
}
