package nn.pp.rc;

import java.awt.*;
import java.util.*;
import java.net.*;

public abstract class ForensicPanel extends Panel {
    protected URL codeBase;
    public RCHandler rcHandler;
    
    public ForensicPanel(URL codeBase) {
    	this.codeBase = codeBase;
    }
    
    public void setRCHandler(RCHandler rcHandler) {
    	this.rcHandler = rcHandler;
    }
    
    public abstract void init(boolean showEvents, boolean localOnly, boolean noKbd, boolean showReplay, String kbdLayout);
    
    public abstract void handleSasEvent(SasEvent evt);
    
    public abstract void handleSpEvent(SpEvent evt);
    
    public abstract void setFramebufferFormat(int width, int height, int bitsPerPixel);
    
    public abstract void setSessionInfo(RecordedSessionInfo info);
    
    public void newKbdMapping(Locale locale) { }
    
    public void newKbdLayout(String layout) { }

    public void show() { super.show(); }

    public void hide() { super.hide(); }
}
