package nn.pp.rc;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.text.*;
import java.util.*;
import nn.pp.rckbd.*;

public class HotkeyMenu extends PopupMenu
{
    public static final boolean debug = false;
    ServerConsolePanelBase frame;    
    KeyEventHandler keh;
    PrintStream logger;
        
    int keypause;
    int itemCount = 0;
    Menu plain_menu = new Menu();
    static final int KEYDELI_ADD	  = 0xf0;
    static final int KEYDELI_SEPERATE	  = 0xf1;
    static final int KEYDELI_PAUSE	  = 0xf2;
    static final int KEYDELI_RELEASE_LAST = 0xf3;
	
    public HotkeyMenu(String name, ServerConsolePanelBase frame, KeyEventHandler keh,
		       String[] hotkeys, String[] hotkeycodes, String[] hotkeynames,
		       PrintStream logger, boolean kvm_hot, int keypause) {	
	super(name);
	this.frame = frame;
	this.logger = logger;
	this.keh = keh;
	this.keypause = keypause;
	
	// check wether our two arrays have the same length
	int l = hotkeys.length;
	if(l != hotkeycodes.length) {
	    logger.println(T._(
	        "Console: WARNING: hotkey definition mismatch, some buttons will be ignored"));
	    l = Math.min(hotkeys.length, hotkeycodes.length);
	}
	
	for(int i = 0; i < l; ++i) {
	    try {
		MenuItem b = null;
		MenuItem mItem = null;
		if(hotkeycodes[i] != null && hotkeycodes[i].length() != 0) {
		    if(hotkeycodes[i].startsWith("kvm")) {
		        if ( kvm_hot ) {
		            b = new KvmPortItem(hotkeys[i], hotkeycodes[i]);
		            mItem = new KvmPortItem(hotkeys[i], hotkeycodes[i]);
		            itemCount++;
		        }
		    } else 
		        if ( !kvm_hot ) {
		    	    b = new HotKeyItem(hotkeys[i], hotkeycodes[i], hotkeynames[i]);
		            mItem = new HotKeyItem(hotkeys[i], hotkeycodes[i], hotkeynames[i]);
		       	    itemCount++;
		        }

		    if ( b != null ) {			
		        add(b);
		        plain_menu.add((MenuItem)mItem);
		    }
		}
	    } catch(ParseException e) {
		logger.println(T._("Console: hotkey error:") + " " + e);
	        logger.println(T._("Console: hotkey configuration error: ignored!"));
	    }
	}
    }
    
    public Menu getPlainMenu(String name)
    {
    	plain_menu.setLabel(name);
    	return plain_menu;
    }
    public boolean isEmpty() {
        if ( itemCount > 0 )
          return false;
        else
          return true;
    }
    
    public void _() {
    }

    class HotKeyItem extends MenuItem implements ActionListener {
	private static final String CONFIRM = "confirm";
	private boolean confirm;
	private Vector codes;

	public HotKeyItem(String hotkey, String codes, String name)
	    throws ParseException {
	    setButtonKey(hotkey, codes, name);
	    addActionListener(this);
	}
	
	public void actionPerformed(ActionEvent ev) {
	    //frame.handleFocus((Component)ev.getSource());
	    
	    if(confirm) {
		ConfirmDialog d = new ConfirmDialog( 
		    MessageFormat.format(T._("Do you really want to send \"{0}\"?"),
		                        new Object[] { getLabel() }),
		    T._("Send Key"), ConfirmDialog.OK_CANCEL, true);
		d.show();
		boolean ok = d.ok;
		d.dispose();
		d = null;
		if(ok == false) return;
	    }
	    /*
	     * go through the keys and generate all pressed/released
	     * events according to the delemitters given in the same
	     * keycode vector
	     */
	    Stack relkeys = new Stack();
	    for(int i=0; i<codes.size(); ++i) {
		Short keynr = (Short)codes.elementAt(i);
		short k = keynr.shortValue();
		if(debug) System.out.println("ButtonKey: keyNo: " + keynr);
		switch(k) {
		  case KEYDELI_PAUSE:
		      try{Thread.sleep(keypause);}catch(Exception e){}
		      break;
		  case KEYDELI_SEPERATE:
		      releaseStackKeys(relkeys);
		      break;
		  case KEYDELI_RELEASE_LAST:
		      releaseLastStackKey(relkeys);
		      break;
		  case KEYDELI_ADD:
		      break;
		  default:
		      relkeys.push(keynr);
		      keh.internalPressed(keynr, KeyEventHandler.KEYBOARD);
		}
	    }
	    releaseStackKeys(relkeys);
	}

	private void releaseStackKeys(Stack keys) {
	    try {
		while(true) {
		    Short keynr = (Short)keys.pop();
		    keh.released(keynr, KeyEventHandler.KEYBOARD);
		}
	    } catch (EmptyStackException finish) {}
	}

	private void releaseLastStackKey(Stack keys) {
	    try {
		Short keynr = (Short)keys.pop();
		keh.released(keynr, KeyEventHandler.KEYBOARD);
	    } catch (EmptyStackException finish) {}
	}
	    
	private void setButtonKey(String text, String kcodes, String name)
	    throws ParseException {

	    // confirm or not confirm
	    if (text==null || text.length()==0)
		throw new ParseException(text, 0);
	    String keyText = text.trim();
	    confirm = false;
	    if(keyText.startsWith(CONFIRM)) {
		confirm = true;
		keyText = keyText.substring(CONFIRM.length());
		keyText = keyText.trim();
	    }
	    if (name != null && name.length() > 0) {
		setLabel(name + " (" + keyText + ")");
	    } else {
		setLabel(keyText);
	    }
	    
	    // parse the associated codes
	    codes = new Vector();
	    StringTokenizer st = new StringTokenizer(kcodes);
	    while(st.hasMoreTokens()) {
		try {
		    int c = Integer.parseInt(st.nextToken(), 16);
		    codes.addElement(new Short((short)c));
		} catch(NumberFormatException e) {
		    throw new ParseException(kcodes, 0);
		}
	    }
	}
    }

    class KvmPortItem extends MenuItem implements ActionListener {
	short portno;
	
	public KvmPortItem(String hotkey, String code)
	    throws ParseException {
	    super(hotkey);
	    StringTokenizer st = new StringTokenizer(code);
	    // second token is expected to be our port number
	    try {
		st.nextToken();
		portno = Short.parseShort(st.nextToken(), 10);
	    } catch(Exception e) {
		throw new ParseException(code, 0);
	    }
	    addActionListener(this);
	}
	
	public void actionPerformed(ActionEvent ev) {
	    frame.console.switchKvmPort(portno);
	}
    }
}
