package nn.pp.rc;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.*;

public class ImageLoader {
    private Hashtable imghash;
    Toolkit kit;
    private URL codeBase;
    private JVMVersionInfo verInfo;
    
    public ImageLoader(URL codeBase) {
	kit = Toolkit.getDefaultToolkit();
	imghash = new Hashtable(5);
	this.verInfo  = JVMVersionInfo.getJVMVersionInfo();
	this.codeBase = codeBase;
    }

    public Image loadImage(String imgname) {
	Image img = null;
	if((null != imgname) && (null == (img = (Image)imghash.get(imgname)))){
	    // netscape and microsoft hack, arghhh
	    String jv = System.getProperty("java.vendor");
	    if(jv.startsWith("Netscape")) {
		img = getImageOldJava(imgname);
	    } else if (verInfo.isPJava()) {
		// PJava
		if (codeBase != null) {
		    try {
		    	URL imurl = new URL(codeBase, "/" + imgname);
		    	img = Toolkit.getDefaultToolkit().getImage(imurl);
		    } catch (MalformedURLException e) {};
		}
	    } else {
		// all others hopefully work as specified
		URL imurl = getClass().getClassLoader().getResource(imgname);
		img = Toolkit.getDefaultToolkit().getImage(imurl);
	    }
	    if(img != null) imghash.put(imgname, img);
	}
	return img;
    }

    /**
     * workaround for netscape's lack of resource support,
     * i.e. netscape can't load resources out of jar-files
     * this is netscapes suggestion how to deal with that
     */
    private Image getImageOldJava(String imgname) {
	Image img = null;
	try {
	    InputStream in;
	    in = getClass().getClassLoader().getResourceAsStream(imgname);
	    if(null == in) return null;
	    byte[] buffer = new byte[in.available()];
	    in.read(buffer);
	    img = Toolkit.getDefaultToolkit().createImage(buffer);
	} catch (java.io.IOException e) {
	    System.err.println("ImageLoader: getImageOldJava: " + e);
	}
	return img;
    }
}
