package nn.pp.rc;

import java.awt.*;
import java.awt.image.*;
import java.io.*;

/**
 * Painter specialiced for java 1.4
 * @author Thomas Breitfeld, Peppercon AG
 */
public class J14TrueColorRFBRenderer extends TrueColorRFBRenderer {
    static RenderingHints rhsmoth
	= new RenderingHints(RenderingHints.KEY_INTERPOLATION,
			     RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    private boolean repaint_done;
    private VolatileImage vvimg;
    private boolean interpolcabable = true;
    private boolean interpol = false;

    public J14TrueColorRFBRenderer(Component comp) {
	super(comp);
	comp.setFocusTraversalKeysEnabled(false);
    }	

    public void sendUpdateMsg() throws IOException {
	repaint();
    }

    public void setRenderSize(Dimension d) {
	super.setRenderSize(d);
	mysize = d;
	createVImg(d);
    }

    public void setInterpol(boolean ip) {
	if(interpol != ip) {
	    interpol = ip;
	    repaint();
	}
    }

    private boolean initialPaint = true;
    
    public void paint(Graphics g, boolean scale, Dimension scalesize) {
	if(vimg == null) return;
	do {
	    switch(vvimg.validate(comp.getGraphicsConfiguration())) {
	      case VolatileImage.IMAGE_INCOMPATIBLE:
		  System.out.println("VolatileImage.IMAGE_INCOMPATIBLE");
		  // old vImg doesn't work with new Graphics, re-create it
		  createVImg(mysize);
	      case VolatileImage.IMAGE_RESTORED:
		  System.out.println("VolatileImage.IMAGE_RESTORED");
		  gvimg.dispose();
		  gvimg = vvimg.createGraphics();
		  // Contents need to be restored, we rely on the server
		  gvimg.setColor(Color.black);
		  gvimg.fillRect(0, 0, mysize.width, mysize.height);
		  try {
		      rfb.writeFullFramebufferUpdateRequest();
		  } catch(IOException ignore) {}
		  break;
	      case VolatileImage.IMAGE_OK:
		  if (initialPaint) {
		      System.out.println("VolatileImage.IMAGE_OK, but sending FB update request");
		      try {
			  rfb.writeFullFramebufferUpdateRequest();
		      } catch (IOException ignore) { }
		  }
		  break;
	    }
	    if(scale) {
		if(interpolcabable && interpol) {
		    Graphics2D g2d = (Graphics2D)g;
		    g2d.setRenderingHints(rhsmoth);
		}
		try {
		    paintContent(g, scale, scalesize);
		} catch(ImagingOpException e) {
		    interpolcabable = false;
		}
	    } else {
		paintContent(g, scale, scalesize);
	    }
	    initialPaint = false;
	} while (vvimg.contentsLost());
    }

    public void repaint() {	
	comp.repaint();
    }
    
    private void createVImg(Dimension d) {
	if(vimg != null) vimg.flush();
	if(gvimg != null) gvimg.dispose();
	vimg = vvimg = comp.createVolatileImage(d.width, d.height);
	gvimg = vvimg.createGraphics();
    }

    public String toString() {
	String isa, tv;
	if(null == vimg) {
	    isa = tv = "na";
	} else {
	    ImageCapabilities ic = vvimg.getCapabilities();
	    isa = "" + ic.isAccelerated();
	    tv = "" + ic.isTrueVolatile();
	}
	return getClass().toString()
	    + "Console: TrueVolatile=" + tv + " isAccelerated=" + isa;
    }
}
