package nn.pp.rc;

import java.awt.*;
import java.awt.event.*;
import java.io.*;

/**
 * Mouse wheel handler for Java >= 1.4
 */
public class J14WheelHandler {

    private RCProto proto = null;

    public void setRCProto(RCProto proto) {
	this.proto = proto;
    }

    public boolean processWheelEvent(MouseEvent e, int pointerMask) {
	if (!(e instanceof MouseWheelEvent))
	    return false;
	
	MouseWheelEvent we = (MouseWheelEvent) e;
	try {
	    proto.writePointerEvent(false, 0, 0,
				    we.getWheelRotation(),
				    pointerMask); 
	} catch (IOException ex) { 
	    System.out.println("Could not write WheelEvent: "
			       + ex.getMessage());
	}
	return true;
    }
}
