package nn.pp.rc;

public class JVMVersionInfo
{
    private static int jvmajor = 0;
    private static int jvminor = 0;
    private static String jvendor = "";   
    static JVMVersionInfo vi = null;
  
    public static JVMVersionInfo getJVMVersionInfo() {
	if (vi == null) vi = new JVMVersionInfo();

	return vi;
    }

    public JVMVersionInfo() {
	String jvs = System.getProperty("java.version");
	jvendor = System.getProperty("java.vendor");
	try {
	    int fdot, sdot;
	    String jvsma = jvs.substring(0, fdot = jvs.indexOf('.'));
	    jvmajor = Integer.valueOf(jvsma).intValue();
	    sdot = jvs.indexOf('.', fdot + 1);
	    String jvsmi = jvs.substring(fdot + 1,
					 sdot < 0 ? jvs.length() : sdot);
	    jvminor = Integer.valueOf(jvsmi).intValue();
	} catch (Exception ignore) {}
	
	System.out.println("JVMVersionInfo: java.vender=" + jvendor + " java.version="
			   + jvs + " major=" + jvmajor + " minor=" + jvminor);
    }
    
    public boolean isJava12() {
    	if(jvmajor == 1 && jvminor >= 2) return true;
	return false;
    }

    public boolean isJava13() {
    	if(jvmajor == 1 && jvminor >= 3) return true;
	return false;
    }

    public boolean isJava14() {
	if(jvmajor == 1 && jvminor >= 4) return true;
	return false;
    }

    public boolean isJava15() {
	if(jvmajor == 1 && jvminor >= 5) return true;
	return false;
    }

    public boolean isPJava() {
	if(jvmajor == 3 && jvminor == 1) return true;
	return false;
    }
    
    public boolean isNSJava() {
	if(jvendor.startsWith("Netscape")) return true;
	else return false;
    }

    public boolean isMSJava() {
	if(jvendor.startsWith("Microsoft")) return true;
	else return false;
    }

    public String toString() {
	return new String("JVMVersionInfo: Java13=" + isJava13() + ", Java14=" + isJava14() + ", Java15=" + isJava15() +
			  ", PJava=" + isPJava() + "isNSJava=" + isNSJava() + ", isMSJava=" + isMSJava());
    }
}
