package nn.pp.rc;

import java.awt.*;
import java.awt.event.*;
import java.io.*;

/**
 * Standard (absolute) mouse movements
 *
 */

public class MouseHandlerAbsolute extends MouseHandler {
    int pointerMask = 0;
    ContentScalingInfo	 scinfo;
    
    public MouseHandlerAbsolute(Component comp, ContentScalingInfo scinfo) {
	super(comp);
	this.scinfo = scinfo;
    }
    
    protected void processMouseEvent(MouseEvent me) {
	int eID = me.getID();
	Point fbMousePos = new Point(
		(int)((double)me.getX() / scinfo.getScale().getX()), 
		(int)((double)me.getY() / scinfo.getScale().getY())); 

	switch (eID) {
	  case MouseEvent.MOUSE_PRESSED:
	      comp.requestFocus();
	  case MouseEvent.MOUSE_RELEASED:
	      pointerMask = getPointerMask(me);
	  case MouseEvent.MOUSE_MOVED:
	  case MouseEvent.MOUSE_DRAGGED:
	      try {
		  proto.writePointerEvent(false,
			  (int)fbMousePos.getX(), (int)fbMousePos.getY(),
			  0, pointerMask);
	      } catch (IOException e) {
		  System.out.println("Could not write MouseEvent: "
				     + e.getMessage());
	      }
	      break;
	  case MouseEvent.MOUSE_EXITED:
	  case MouseEvent.MOUSE_ENTERED:
	      clearPointerMask();
	      break;
	}

	oldPos.x = me.getX();
	oldPos.y = me.getY();
    }

    public void actionPerformed(ActionEvent e) {
    }

    public boolean needMouseHandling() {
	return true;
    }

    public void handleMouseSyncKey() {
	try {
	    proto.writeMouseSyncEvent(RFBproto.MouseSyncFast);
	} catch (Exception ec) {
	    ec.printStackTrace();
	}
    }

    public int  getPointerMask() {
	return pointerMask;
    }
}
