package nn.pp.rc;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.io.*;
import java.text.*;

/**
 * Special fallback (relative) mouse movements
 * using the captured mouse pointer
 */

public class MouseHandlerRelative extends MouseHandler {
    private static Robot robot = null;
    private Object	 mousemtx = new Object();
    private int		 dx, dy, oldPointerMask=0;
    private boolean	 handleMouse = false;
    private CustomCursor cursors;
    private PrintStream  logger;
    private String	 synckey;
    private boolean	 toldUser = false;
    ContentScalingInfo	 scinfo;

    public MouseHandlerRelative(Component comp, ContentScalingInfo scinfo, CustomCursor cursors,
				PrintStream logger, String synckey)
	throws AWTException, SecurityException {
	super(comp);
	this.cursors = cursors;
	this.logger  = logger;
	this.synckey = synckey;
	this.scinfo = scinfo;
	if (robot == null) robot = new Robot();
	new GenericTimer(50, this).start();
    }

    protected void processMouseEvent(MouseEvent me) {
	int eID = me.getID();
	Dimension dim = comp.getSize();
	int compZeroX = dim.width / 2;
	int compZeroY = dim.height / 2;
	Point compPos = comp.getLocationOnScreen();
	int scrZeroX = (int)compPos.getX() + compZeroX;
	int scrZeroY = (int)compPos.getY() + compZeroY;

	if (!handleMouse) {   
	    if (eID == MouseEvent.MOUSE_RELEASED) {
		handleMouse = true;
		comp.setCursor(cursors.getCursor("Transparent").cursor);
		logger.println(MessageFormat.format(T._("Single mouse mode entered, press {0} to leave"),
		                                    new Object[] { synckey }));
		// prevent detection of non-existing initial movement
		robot.mouseMove(scrZeroX, scrZeroY);
	    } else if (!toldUser){
		logger.println(T._("Single mouse mode (click into screen to start)"));
		toldUser = true;
	    }
	    return;
	}
	
	switch (eID) {
	  case MouseEvent.MOUSE_PRESSED:
	      comp.requestFocus();
	  case MouseEvent.MOUSE_RELEASED:
	      writeMouseRelative();
	      oldPointerMask = getPointerMask(me);
	      try {
		  proto.writePointerEvent(true, 0, 0, 0, oldPointerMask);
	      } catch (IOException e) {
		  System.out.println("Could not write relative MouseEvent: "+e.getMessage());
	      }
	      break;
	  case MouseEvent.MOUSE_EXITED:
	      handleMouseSyncKey();
	      break;
	  case MouseEvent.MOUSE_ENTERED:
	      clearPointerMask();
	      break;
	  case MouseEvent.MOUSE_MOVED:
	  case MouseEvent.MOUSE_DRAGGED:
	      Point2D scaling = scinfo.getScale();
	      Point fbMousePos = new Point(
		      (int)((double)me.getX() / scaling.getX()), 
		      (int)((double)me.getY() / scaling.getY())); 
	      Point oldFbMousePos = new Point(
		      (int)((double)oldPos.getX() / scaling.getX()), 
		      (int)((double)oldPos.getY() / scaling.getY())); 

	      // hack: to filter out robot movement events, we ignore movements
	      //       to the exact center
	      if (me.getX() != compZeroX || me.getY() != compZeroY) {
		  synchronized (mousemtx) {
		      dx += (fbMousePos.getX() - oldFbMousePos.getX());
		      dy += (fbMousePos.getY() - oldFbMousePos.getY());
		  }
		  // move back to center to keep mouse captured
		  robot.mouseMove(scrZeroX, scrZeroY);
	      }
	      oldPos.setLocation(me.getPoint());
	      break;
	}
    }

    public void actionPerformed(ActionEvent e) {
	writeMouseRelative();
    }

    /**
     * write pending relative mouse movement
     */
    private void writeMouseRelative() {
	synchronized (mousemtx) {
	    if ((dx == 0 && dy == 0) || proto == null) return;
	    try {
		proto.writePointerEvent(true, dx, dy, 0, oldPointerMask);
	    } catch (IOException e) {
		System.out.println("Could not write relative MouseEvent: " + e.getMessage());
	    }
	    dx = dy = 0;
	}
    }

    public boolean needMouseHandling() {
	return false;
    }

    public void handleMouseSyncKey() {
	handleMouse = false;
	comp.setCursor(cursors.getCurrentCursor().cursor);
	logger.println(T._("Single mouse mode left, click to control mouse again"));
    }

    public int  getPointerMask() {
	return oldPointerMask;
    }
}
