// ****************************************************************************
//
// RemoteConsoleApplet.java: Applet
//
// ****************************************************************************
/*
   <applet 
      code="RemoteConsoleApplet.class" 
      archive="rc.jar"
      width="1" 
      height="1">
      <param name="APPLET_ID" value="bla bla bla">
      <param name="HOST" value="192.168.101.73">
      <param name="InFrame" value="no">
      <param name="OnCloseURL" value="http://www.heise.de">
      <param nane="ONCloseURLTarget" value="_blank">
   </applet>
*/
package nn.pp.rc;

import java.applet.*;
import java.awt.*;
import java.text.*;
import java.awt.image.ImageObserver;
import java.net.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.beans.PropertyChangeEvent;
import nn.pp.rckbd.*;

/**
 * The RemoteConsoleApplet is the main class for starting the remote
 * console application. The applet itself has no grapical representation
 * so far but opens another frame that is displaying the console window
 * of the remote host
 *
 * @author Thomas Breitfeld, Peppercon AG
 */
public class RemoteConsoleApplet extends Applet implements StateMessageInterface, ParameterReader
{
    private RemoteConsoleLoader loader;
    private Image logo = null, logo_off = null;
    private URL logourl = null;
    boolean inFrame;
    private boolean bConState = false;
    private Color bgcolor;
    private Color fgcolor;
    private String stateMsg   = T._("Remote Console connecting...");
    private String stateMsgOn = T._("Remote Console connected!");
    private String stateMsgOff= T._("Remote Console disconnected!");
    private static final int INVALID_X_POS = 9999;
    private int stateMsgXpos = INVALID_X_POS;
    
    public RemoteConsoleApplet() {
	this.enableEvents(AWTEvent.MOUSE_EVENT_MASK);
	setLayout(new BorderLayout());
    }

    public void init() {
    	try {
   	    runRemoteConsole();
    	} catch (Exception e) {
    	    e.printStackTrace();
    	}
    }
    
    private void runRemoteConsole() throws Exception {
	String lang = readParameter("LANGUAGE", false);
	if(lang != null) {
	    T.loadCatalog(lang);
    	    stateMsg   = T._("Remote Console connecting...");
    	    stateMsgOn = T._("Remote Console connected!");
    	    stateMsgOff= T._("Remote Console disconnected!");
	}
	
	String s = readParameter("InFrame", false);       // will we run in an extra Frame?
	if(s != null && s.equals("yes")) { // yes, extra frame
	    inFrame = true;
	} else {                           // we use the applet graphics
	    inFrame = false;
	}

	loader = new RemoteConsoleLoader(this, this);
	loader.init(inFrame, getCodeBase(), getAppletContext());

	if(inFrame) { // yes, extra frame
	    String url = readParameter("OnCloseURL", false);
	    if(url != null)
		loader.setOnCloseURL(url, readParameter("OnCloseURLTarget", false));

	    // lets set the requested bgcolor, fgcolor and logo in the gray box
	    try {
		String cs = readParameter("bgcolor", false);
		if (cs != null) { 
		    bgcolor = new Color(Integer.valueOf(cs.substring(1), 16).intValue());
		} else {
		    bgcolor = Color.white;
		}
		cs = readParameter("fgcolor", false);
		if (cs != null) { 
		    fgcolor = new Color(Integer.valueOf(cs.substring(1), 16).intValue());
		} else {
		    fgcolor = Color.black;
		}
		try {
		    String file = readParameter("logo", false);
		    if (file != null && file.length()>0) {
			URL logoloc = new URL(getCodeBase(), file);
			System.out.println(logoloc);
			logo = getImage(logoloc);
		    }
		} catch (MalformedURLException ignore) {}
		try {
		    String file = readParameter("logo_off", false);
		    if (file != null && file.length()>0) {
			URL logoloc_off = new URL(getCodeBase(), file);
			System.out.println(logoloc_off);
			logo_off = getImage(logoloc_off);
		    }
		} catch (MalformedURLException ignore) {}
		try {
		    logourl = new URL(readParameter("logourl", false));
		} catch (MalformedURLException ignore) {}
	    } catch (Exception e) { System.out.println("rca: ERROR: " + e);}
	} else {
	    add(loader, BorderLayout.CENTER);
	}
    }

    public void start() {
	System.out.println("rca: start...");
    }

    public void stop() {
	System.out.println("rca: stop...");
    }    
    
    public void destroy() {
	System.out.println("rca: destroy...");
	if (loader != null) loader.destroy();
	loader = null;	// release the loader
	if(logo != null) logo.flush();
	if(logo_off != null) logo.flush();
    }

    public void setStateMessage(boolean conState) {
	bConState = conState;
	stateMsgXpos = INVALID_X_POS;
	repaint();
    }
    
    public void paint(Graphics g) {
	if(inFrame) {
	    Image logo_show = (bConState==true) ? logo : logo_off;
	    
	    Dimension d = getSize();
	    g.setColor(bgcolor);
	    g.fillRect(0, 0, d.width, d.height);

	    if (logo_show != null) {		
	        int iw = logo_show.getWidth(this);
	        int xpos = iw > 0 ? (d.width - iw) / 2 : 0;
	        
		g.drawImage(logo_show, xpos, 0, bgcolor, this);
            }
	    if (loader.displayStateMsg()) {
		String msg = (bConState==true) ? stateMsgOn : stateMsgOff;
		if(INVALID_X_POS == stateMsgXpos) {
		    FontMetrics fm = g.getFontMetrics();
		    stateMsgXpos = (d.width - fm.stringWidth(msg)) / 2;
		}
		g.setColor(fgcolor);
		g.drawString(msg, stateMsgXpos, loader.adjustStateMsgPos(d.height));
	    }
	} else {	    
	    super.paint(g);
	}
    }

    public void processMouseEvent(MouseEvent e) {
	switch(e.getID()) {
	  case MouseEvent.MOUSE_CLICKED:
	      if(logourl != null)
		  getAppletContext().showDocument(logourl, "_top");
		break;		
	  case MouseEvent.MOUSE_EXITED:
	      if(logourl != null)
		  setCursor(Cursor.getDefaultCursor());
	      break;
	  case MouseEvent.MOUSE_ENTERED:
	      if(logourl != null)
		  setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
	}
    }
   
    /*
    public void printMemInfo(String prefix) {
	Runtime rt = Runtime.getRuntime();
	System.out.println(prefix
			   + "Memory: free=" + rt.freeMemory()/1000 + "Kbytes"
			   + " total=" + rt.totalMemory()/1000 + "Kbytes"
			   + " max=" + rt.maxMemory()/1000 + "Kbytes");
    }
    */

    /**************************************************************************
    * methods overridden from ParameterReader interface                       *
    **************************************************************************/

    public void parameterError(String s) {
	System.out.println(s);
	add(new Label(T._("Fatal Error:") + " " + s));
	Thread.currentThread().stop();
    }

    public String readParameter(String name, boolean required) {
    	String s = null;
    	
    	if (!name.startsWith("connection.")) {
    		/* regular parameter */
    		s = getParameter(name);
    	} else {
    		/* parameter within the connection parameter XML String */
		/* this is a really crude way to access the attributes but it works efficient */
    		name = name.substring(11);
		String connection = getParameter("connection");
		String[] res;
		
		try {
			connection = connection.replaceAll("\n", "");
			// split at 'keyword="', value is the 2nd part of the result
			res = connection.split(name + "=\"");
			// separate value from rest by splitting at first '"' and picking 1st result  
			s = (res[1].split("\""))[0];
		} catch (Exception e) { /* ignore any nullpointer or OutOfBounds exceptions */ };
    	}
    	
	if (s == null && required) {
	    parameterError(MessageFormat.format(T._("Required Applet parameter \"{0}\" not found"),
	               new Object[] { name }));
	}

	return s;
    }
	
    public String[] readArrayParameter(String basename) {
	int index = 0;
	String s;

	while (null != (s = getParameter(basename + index))) ++index;
	String[] hotkeys = new String[index];
	for(int i = 0; i < index; ++i) {
	    s = getParameter(basename + i);
	    hotkeys[i] = s;
	}
	return hotkeys;
    }
    
    public String getRemoteHost() {
    	return getCodeBase().getHost();
    }

}
