package nn.pp.rc;

/**
 * simple and classical Semaphore class.
 * the class can be initialized with a value
 * greater than 1 and will allow as many accesses
 * as the value indicates. 
 * Also each signal will be remembered
 *
 * @author Thomas Breitfeld Peppercon AG
 * @version $Id: Semaphore.java,v 1.1 2002-08-19 11:01:02 miba Exp $
 */
public class Semaphore {

    private int value;

    /** 
     * constructs a new Semaphore with the given 
     * initial value
     */
    public Semaphore(int n) {
	value = n;
    }

    /**
     * tries to aquire the Semaphore
     * and blocks until it will become available
     */
    public synchronized void get() {
	while(value < 1) {
	    try {
		wait();
	    }catch( InterruptedException e ) {
		e.printStackTrace();
	    }
	}
	value--;
    }

    /**
     * signal and releases the semaphore
     */
    public synchronized void post() {
	value++;
	notify();
    }
}
