package nn.pp.rc;

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.beans.*;
import java.lang.reflect.*;

import nn.pp.drvredir.*;

/**
 * The ServerConsoleFrame is the main Window of the 
 * Remote Console displaying all the controls.
 * In order to contact a server the Frame has to be 
 * made working using the work method that requires 
 * a profile parameter defining all protocoll specific
 * parameters
 */
public class ServerConsoleFrame 
    extends Frame
{
    private ServerConsolePanelBase panel;
    private DrvRedirPanel drvRedirPanel;
    private URL onCloseURL = null;
    private String onCloseURLTarget = null;
    private AppletContext appletContext = null;
    private URL codeBase;
    private ClassLoader classLoader;
    private RFBProfile profile;
    //public String title;    
    private ForensicPanel forensicPanel;

    private String title_extension;

    /*
     * Constructs the frame and adds the given
     * Console Panel to it...
     */
    public ServerConsoleFrame(URL codeBase, AppletContext appletContext, ClassLoader classLoader, RFBProfile profile,
			      String title, String title_extension,
			      ServerConsolePanelBase panel) {
        super(title + " " + T._("Remote Console") + (title_extension));
	//this.title = title;
	this.panel = panel;
	this.title_extension = title_extension;
	this.codeBase = codeBase;
	this.classLoader = classLoader;
	this.profile = profile;
	this.appletContext = appletContext;
	enableEvents(WindowEvent.WINDOW_CLOSING |
		     WindowEvent.WINDOW_ICONIFIED |
		     WindowEvent.WINDOW_DEICONIFIED |
		     WindowEvent.WINDOW_LOST_FOCUS |
		     WindowEvent.WINDOW_GAINED_FOCUS |
		     WindowEvent.WINDOW_DEACTIVATED);
	add(panel, BorderLayout.CENTER);
	
        drvRedirPanel = loadDrvRedirPanel(codeBase, profile);
        	
        if (drvRedirPanel != null) {
            panel.setDrvRedirPanel(drvRedirPanel);
        } else {
            System.out.println("Could not load Drive Redirection classes.");
        }
        panel.hideDrvRedirButton();
    }
    
    void setBoardName(String boardname) {
        setTitle(boardname + " " + T._("Remote Console") + (title_extension));
    }
    
    /**
     * show or hide the drive redirection panel
     */
    void showDriveRedirection(boolean show) {
    	if (drvRedirPanel == null) {
    	    return;
    	}
    	
    	if (show) {
    	    add(drvRedirPanel, BorderLayout.NORTH);
    	    drvRedirPanel.open(this);
    	} else {
    	    remove(drvRedirPanel);
    	}
	panel.console.forceAdjustSize();
    	pack();
    }

    /**
     * show or hide the forensic panel
     */
    void showForensic(boolean show) {
    	if (forensicPanel == null) {
    	    return;
    	}
    	
    	if (show) {
    	    add(forensicPanel, BorderLayout.SOUTH);
    	    forensicPanel.show();
    	} else {
    	    remove(forensicPanel);
    	    forensicPanel.hide();
    	}
    	pack();
    }

    /**
     * this is the cleanup function that stops the current operation
     * and frees all resources associated with this frame
     */
    public void close() {
	hide();

	Class    fclass = Frame.class;
	Class[]	 params  = new Class[1];
	Object[] arglist = new Object[1];
	params[0] = Integer.TYPE;
	arglist[0]= new Integer(Frame.NORMAL);	
	try {
	    Method me = fclass.getMethod("setState", params);
	    me.invoke(this, arglist);
	} catch (Exception e) {
	    System.out.println("setState failed: "+e.getMessage());
	}

	dispose();
	panel.close();
	if (drvRedirPanel != null) {
	    drvRedirPanel.close();
	}
	if (forensicPanel != null) {
	    forensicPanel.hide();
	}
    }
    
    /**
     * if the window is closed we make sure 
     * everything is cleaned up properly
     */
    protected void processWindowEvent(WindowEvent event) {
	if (event.getID() == WindowEvent.WINDOW_CLOSING) {
	    close();
	    if(onCloseURL != null && appletContext != null) {
		if(onCloseURLTarget != null)
		    appletContext.showDocument(onCloseURL, 
					       onCloseURLTarget);
		else
		    appletContext.showDocument(onCloseURL);
	    }
	} else if (event.getID() == WindowEvent.WINDOW_ICONIFIED) {
	    //	    panel.sendUpdateReqs(false);
	} else if (event.getID() == WindowEvent.WINDOW_DEICONIFIED) {
	    //	    panel.sendUpdateReqs(true);
	} else if (event.getID() == WindowEvent.WINDOW_LOST_FOCUS || event.getID() == WindowEvent.WINDOW_DEACTIVATED) {
	    //System.out.println("Lost focus, leaving double mouse mode");
	    panel.releaseSingleMouse();
	} else if (event.getID() == WindowEvent.WINDOW_GAINED_FOCUS) {
	    panel.handleFocus(null);
	}
    }
    
    public void setOnCloseURL(String url, String target) {
	if (codeBase != null) {
	    try {
	    	onCloseURL = new URL(codeBase, url);
	    	onCloseURLTarget = target;
	    	//System.out.println(onCloseURL + " " + onCloseURLTarget);
	    } catch(MalformedURLException e) {
	    	panel.logger.println(T._("Console: OnCloseURL:") + " " + e);
	    }
	}
    }
    
    private DrvRedirPanel loadDrvRedirPanel(URL codeBase, RFBProfile profile) {
    	if (JVMVersionInfo.getJVMVersionInfo().isJava14()) {
    	    return new DrvRedirPanel(codeBase, profile);
    	}
    	
    	return null;
    }
    
    ForensicPanel addForensicPanel(boolean showEvents, boolean localOnly, boolean noKbd, boolean showReplay, String kbdLayout) {
    	if (forensicPanel == null) {
    	    J14ForensicStaticLoader l = new J14ForensicStaticLoader();
    	    forensicPanel = l.loadSasPanel(classLoader, codeBase);
    	}

    	if (forensicPanel != null) {
    	    forensicPanel.init(showEvents, localOnly, noKbd, showReplay, kbdLayout);
    	}
    	
    	return forensicPanel;
    }
    
    class J14ForensicStaticLoader {
    	public ForensicPanel loadSasPanel(ClassLoader classLoader, URL codeBase) {
   	    ForensicPanel p = null;

	    try {
    	        Class cl = Class.forName("nn.pp.sara.SasForensicPanel", false,
					 classLoader);
   	        Class cstrtypes[] = { URL.class, panel.defkbd.getClass(), panel.getCurMapping().getClass() };
            
   	        Constructor sasConstructor = cl.getConstructor(cstrtypes);
   	        
   	        Object arglist[] = { codeBase, panel.defkbd, panel.getCurMapping() };
   	        p = (ForensicPanel)sasConstructor.newInstance(arglist);
		
   	    } catch (Exception e) { // should never happen
   	        System.out.println("loadSasPanel: " + e);
   	        e.printStackTrace();
	    }
	    return p;
	}
    }
    
}
