package nn.pp.rc;

import java.util.*;

public class SpEvent {
    public final static int SessionTimes = 1;
    public final static int ReplayTime = 2;
    public final static int Played = 3;
    public final static int Paused = 4;
    public final static int Stopped = 5;
    
    public int type;
    
    public class SpSessionTimes {
    	public Date start, end;
    	
    	public SpSessionTimes(Date start, Date end) {
    	    this.start = start;
    	    this.end = end;
    	}
    }
    
    public class SpReplayTime {
    	public Date time;
    	
    	SpReplayTime(Date time) {
    	    this.time = time;
    	}
    }
    
    public SpSessionTimes sessionTimes;
    public SpReplayTime replayTime;
    
    SpEvent() {
    	type = 0;
    }
    
    SpEvent(int rfbType) {
    	switch (rfbType) {
    	    case RFBproto.SpCommandPlay:
    	    	type = Played;
    	    	break;
    	    case RFBproto.SpCommandPause:
    	    	type = Paused;
    	    	break;
    	    case RFBproto.SpCommandStop:
    	    	type = Stopped;
    	    	break;
    	}
    }
    
    void setSessionTimes(Date start, Date end) {
    	type = SpEvent.SessionTimes;
    	sessionTimes = new SpSessionTimes(start, end);
    }
    
    void setReplayTime(Date time) {
    	type = SpEvent.ReplayTime;
    	replayTime = new SpReplayTime(time);
    }
    
    void played() {
    	type = SpEvent.Played;
    }
    
    void paused() {
    	type = SpEvent.Paused;
    }
    
    void stopped() {
    	type = SpEvent.Stopped;
    }
}
