package nn.pp.rckbd;

import java.util.Hashtable;

public class KeyDef {
    
    public short keynr;	//key number
    public byte page;
    public byte pos_x;
    public byte pos_y;
    public byte size_x;
    public byte size_y;
    public byte keycode;
    public byte modifier;
    public static final short NOP               = -1;
    public static final Short SHORTNOP          = new Short(NOP);
    public static final short PAGE              = -2;
    public static final short POPUP             = -3;
 	
    public static final byte NOMOD              = (byte)0x00;
    public static final byte NORMALMOD          = (byte)0x01;
    public static final byte PERMANENTMOD       = (byte)0x03;
    
    public static final byte MODMASK            = (byte)0x01;
    public static final byte PERMANENTMODMASK   = (byte)0x03;
    
    public KeyDef(int keynr, int page, int pos_x, int pos_y,
		  int size_x, int size_y, byte scan, int modifier) {
  	this.keynr    = (short)keynr;
  	this.page     = (byte)page;
  	this.pos_x    = (byte)pos_x;
  	this.pos_y    = (byte)pos_y;
  	this.size_x   = (byte)size_x;
  	this.size_y   = (byte)size_y;
  	this.keycode  = scan;
  	this.modifier = (byte)modifier;	
    }	
 
    public KeyDef(int keynr, int page, int pos_x, int pos_y, int scan) {
	this(keynr, page, pos_x, pos_y, 1, 1,
	     (byte)scan, NOMOD);
    }

    public KeyDef(int keynr, int page, int pos_x, int pos_y,
		  int size_x, int size_y, int scan, int modifier) {
	this(keynr, page, pos_x, pos_y, size_x, size_y,
	     (byte)scan, modifier);
    }
    
    public boolean isModifier(){
	if((modifier & MODMASK) == NOMOD) return false;
	else return true;
    }  
 
    public boolean isPermanentModifier(){
 	if((modifier & PERMANENTMODMASK) == PERMANENTMOD) return true;
   	else return false;
    }  
 
    public byte getKeyCode(Hashtable modifiers, boolean clicked, int ctrl_counter) {
        byte keycode = this.keycode;
        if (ctrl_counter > 0 && keycode == 74) {
            keycode = 102;
        }
        
        if(clicked) return makePressCode(keycode);
 	else return keycode;
    } 	
 
    static byte makePressCode(byte scan) {
 	Byte hilf = new Byte((byte)(scan | 0x80));
  	return hilf.byteValue();
    }
}	
